<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class UpdateTableForeignKey extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('bond_recipe_productions', function (Blueprint $table) {
            $table->dropForeign(['material_id']);
    
            $table->foreign('material_id')
                ->references('material_id')
                ->on('bond_material_recipes');
        });

        Schema::table('quality_checks', function (Blueprint $table) {
            $table->dropForeign(['material_id']);
    
            $table->foreign('material_id')
                ->references('material_id')
                ->on('bond_material_recipes');
        });

        Schema::table('production_packaging_detail', function (Blueprint $table) {
            $table->dropForeign(['material_id']);
    
            $table->foreign('material_id')
                ->references('material_id')
                ->on('bond_material_recipes');
        });

        Schema::table('invoice_consumable_detail', function (Blueprint $table) {
            $table->foreign('consumable_id')
                ->references('id')
                ->on('consumable_items');
        });


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //Schema::dropIfExists('update_table_forign_key');
    }
}
