@section('css')
    @include('layouts.datatables_css')
@endsection


<div class="form-row">
        <div class="form-group col-sm-4">
                {!! BootForm::text('Packing Id', 'packing_id')->placeholder('Packing Id')->attribute('disabled', 'true')   !!}	 
        </div>
        <div class="form-group col-sm-4">
                {!! BootForm::text('Qty', 'qty')->placeholder('Qty')->attribute('disabled', 'true')   !!}	 
        </div>
        <div class="form-group col-sm-4">
                {!! BootForm::text('Narration', 'narration')->placeholder('Narration')->attribute('disabled', 'true')   !!}	 
        </div>
</div>


<div class="form-row">
<div class="form-group col-sm-12">
<table cellpadding="0" cellspacing="0" border="0" class="dataTable table table-striped" id="dataInputTable">
</table>
</div>
</div>

<!-- Submit Field -->
<div class="form-group col-sm-12">
    {!! Form::submit('Save', ['class' => 'btn btn-primary']) !!}
    <a href="{!! route('consumableSettings.index') !!}" class="btn btn-default">Cancel</a>
</div>

@section('scripts')
    @include('layouts.datatables_js')
@endsection

@push('scripts')
<script>
$(document).ready(function() {

    var dataSet = [
     
    ];

    var settingId = '{{ $settings->packing_id }}';

   

    //var qtyType = ['PERCENTAGE', 'UNIT'];
    
  
    var columnDefs = [
        {
    data: "id",
    title: "Id",
    type: "readonly"
  },{
    data: "material_id",
    title: "Material Id",
  },
   {
      title: "Qty",
      data:'qty',
    }];
  
    var myTable;
  
    myTable = $('#dataInputTable').DataTable({
      "sPaginationType": "full_numbers",
      ajax: {
        url : "{{env('APP_URL')}}" + "/admin/productionPackagings/getPacking/"+settingId,
        // our data is an array of objects, in the root node instead of /data node, so we need 'dataSrc' parameter
       dataSrc : ''
    },
      columns: columnDefs,
          dom: 'Bfrtip',        // Needs button container
            select: 'single',
            responsive: true,
            altEditor: true,     // Enable altEditor
            buttons: [{
              text: 'Add',
              name: 'add'        // do not change name
            },
            {
              extend: 'selected', // Bind to Selected row
              text: 'Edit',
              name: 'edit'        // do not change name
            },
            {
              extend: 'selected', // Bind to Selected row
              text: 'Delete',
              name: 'delete'      // do not change name
           }],
        onAddRow: function(datatable, rowdata, success, error) {
            rowdata['_token'] = "{{ csrf_token() }}";

            $.ajax({
                // a tipycal url would be / with type='PUT'
                url: "{{env('APP_URL')}}" + "/admin/productionPackagings/savePacking/"+settingId,
                type: 'POST',
                data: rowdata,
                success: success,
                error: error
            });
        },
        onDeleteRow: function(datatable, rowdata, success, error) {
            rowdata['_token'] = "{{ csrf_token() }}";
            $.ajax({
                // a tipycal url would be /{id} with type='DELETE'
                url: "{{env('APP_URL')}}" + "/admin/productionPackagings/deletePacking/"+settingId,
                type: 'POST',
                data: rowdata,
                success: success,
                error: error
            });
        },
        onEditRow: function(datatable, rowdata, success, error) {
            rowdata['_token'] = "{{ csrf_token() }}";
            $.ajax({
                // a tipycal url would be /{id} with type='POST'
                url: "{{env('APP_URL')}}" + "/admin/productionPackagings/updatePacking/"+settingId,
                type: 'POST',
                data: rowdata,
                success: success,
                error: error
            });
        }
    });
  
  
  });
  </script>
@endpush