<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConsumableItemsTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('consumable_items', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->timestamps();
            //$table->softDeletes();

            $table->json('name');
            $table->string('spec')->nullable(true);
            $table->string('add_spec')->nullable(true);
            $table->decimal('weight', 25, 2)->nullable(true);
            $table->json('description')->nullable(true);
            $table->decimal('opening_stock', 25, 2)->nullable(true);
            $table->decimal('unit_price', 25, 2)->nullable(true);
            $table->unsignedBigInteger('category_id');
            $table->unsignedBigInteger('opening_stock_unit')->nullable();
            $table->foreign('opening_stock_unit')->references('id')->on('units');
           

            $table->unsignedBigInteger('created_by')->nullable(false);
            $table->unsignedBigInteger('updated_by')->nullable();
           // $table->unsignedBigInteger('deleted_by')->nullable();

            $table->foreign('created_by')->references('id')->on('users');
            $table->foreign('updated_by')->references('id')->on('users');        
            //$table->foreign('deleted_by')->references('id')->on('users'); 

            $table->foreign('category_id')->references('id')->on('consumable_categories');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('consumable_items');
    }
}
