<?php

use Illuminate\Database\Seeder;

class ConnectRelationshipsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /**
         * Get Available Permissions.
         */
        $permissions = config('roles.models.permission')::all();

        /**
         * Attach Permissions to Roles.
         */
        $roleAdmin = config('roles.models.role')::where('name', '=', 'MasterAdmin')->first();
        foreach ($permissions as $permission) {
            $roleAdmin->attachPermission($permission);
        }


        $productionPermissions = config('roles.models.permission')::whereIn('model', ["BondMaterialRecipe", "BondRecipeProduction","QualityCheck","ProductionPackaging",'ConsumableConsumpation'])->where('slug', 'NOT LIKE' , 'delete.%');

        /**
         * Attach Permissions to Roles.
         */
        $roleAdmin = config('roles.models.role')::where('name', '=', 'MasterAdmin')->first();
        foreach ($permissions as $permission) {
            $roleAdmin->attachPermission($permission);
        }


        $roleProductionManager = config('roles.models.role')::where('name', '=', 'ProductionManager')->first();
        foreach ($productionPermissions as $permission) {
            $roleProductionManager->attachPermission($permission);
        }
    }
}
