/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.analysis.Label;
import org.antlr.analysis.NFAConfiguration;
import org.antlr.analysis.NFAContext;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.State;
import org.antlr.analysis.Transition;
import org.antlr.misc.IntSet;
import org.antlr.misc.OrderedHashSet;
import org.antlr.misc.Utils;

public class DFAState
extends State {
    public static final int INITIAL_NUM_TRANSITIONS = 4;
    public static final int PREDICTED_ALT_UNSET = -2;
    public DFA dfa;
    protected List transitions = new ArrayList(4);
    protected int k;
    protected int acceptStateReachable = -2;
    protected boolean resolvedWithPredicates = false;
    protected boolean abortedDueToRecursionOverflow = false;
    protected boolean abortedDueToMultipleRecursiveAlts = false;
    protected int cachedHashCode;
    protected int cachedUniquelyPredicatedAlt = -2;
    protected Set nfaConfigurations = new HashSet();
    protected Set closureBusy = new HashSet();
    protected OrderedHashSet reachableLabels = new OrderedHashSet();

    public DFAState(DFA dFA) {
        this.dfa = dFA;
    }

    public Transition transition(int n) {
        return (Transition)this.transitions.get(n);
    }

    public int getNumberOfTransitions() {
        return this.transitions.size();
    }

    public void addTransition(Transition transition) {
        this.transitions.add(transition);
    }

    public int addTransition(DFAState dFAState, Label label) {
        this.transitions.add(new Transition(label, (State)dFAState));
        return this.transitions.size() - 1;
    }

    public Transition getTransition(int n) {
        return (Transition)this.transitions.get(n);
    }

    public void removeTransition(int n) {
        this.transitions.remove(n);
    }

    public void addNFAConfiguration(NFAState nFAState, NFAConfiguration nFAConfiguration) {
        Label label;
        if (this.nfaConfigurations.contains(nFAConfiguration)) {
            return;
        }
        this.nfaConfigurations.add(nFAConfiguration);
        this.cachedHashCode += nFAConfiguration.state + nFAConfiguration.alt;
        if (nFAState.transition(0) != null && !(label = nFAState.transition((int)0).label).isEpsilon() && !label.isSemanticPredicate()) {
            if (nFAState.transition(1) == null) {
                nFAConfiguration.singleAtomTransitionEmanating = true;
            }
            this.addReachableLabel(label);
        }
    }

    public void addNFAConfiguration(NFAState nFAState, int n, NFAContext nFAContext, SemanticContext semanticContext) {
        NFAConfiguration nFAConfiguration = new NFAConfiguration(nFAState.stateNumber, n, nFAContext, semanticContext);
        this.addNFAConfiguration(nFAState, nFAConfiguration);
    }

    protected void addReachableLabel(Label label) {
        IntSet intSet;
        if (this.reachableLabels.contains(label)) {
            return;
        }
        IntSet intSet2 = intSet = label.getSet();
        int n = this.reachableLabels.size();
        for (int i = 0; i < n; ++i) {
            Label label2 = (Label)this.reachableLabels.get(i);
            IntSet intSet3 = label2.getSet();
            IntSet intSet4 = intSet3.and(intSet);
            if (intSet4.isNil()) continue;
            this.reachableLabels.set(i, new Label(intSet4));
            IntSet intSet5 = intSet3.subtract(intSet);
            if (!intSet5.isNil()) {
                Label label3 = new Label(intSet5);
                this.reachableLabels.add(label3);
            }
            if ((intSet2 = intSet.subtract(intSet3)).isNil()) break;
            intSet = intSet2;
        }
        if (!intSet2.isNil()) {
            Label label4 = new Label(intSet2);
            this.reachableLabels.add(label4);
        }
    }

    public OrderedHashSet getReachableLabels() {
        return this.reachableLabels;
    }

    public Set getNFAConfigurations() {
        return this.nfaConfigurations;
    }

    public void setNFAConfigurations(Set set) {
        this.nfaConfigurations = set;
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    public boolean equals(Object object) {
        DFAState dFAState = (DFAState)object;
        if (object == null) {
            return false;
        }
        if (this.hashCode() != dFAState.hashCode()) {
            return false;
        }
        if (this.nfaConfigurations.size() != dFAState.nfaConfigurations.size()) {
            return false;
        }
        Iterator iterator = this.nfaConfigurations.iterator();
        while (iterator.hasNext()) {
            NFAConfiguration nFAConfiguration = (NFAConfiguration)iterator.next();
            if (dFAState.nfaConfigurations.contains(nFAConfiguration)) continue;
            return false;
        }
        return true;
    }

    public int getUniquelyPredictedAlt() {
        if (this.cachedUniquelyPredicatedAlt != -2) {
            return this.cachedUniquelyPredicatedAlt;
        }
        int n = -1;
        Iterator iterator = this.nfaConfigurations.iterator();
        while (iterator.hasNext()) {
            NFAConfiguration nFAConfiguration = (NFAConfiguration)iterator.next();
            if (nFAConfiguration.resolved) continue;
            if (n == -1) {
                n = nFAConfiguration.alt;
                continue;
            }
            if (nFAConfiguration.alt == n) continue;
            return -1;
        }
        this.cachedUniquelyPredicatedAlt = n;
        return n;
    }

    public int getUniqueAlt() {
        int n = -1;
        Iterator iterator = this.nfaConfigurations.iterator();
        while (iterator.hasNext()) {
            NFAConfiguration nFAConfiguration = (NFAConfiguration)iterator.next();
            if (n == -1) {
                n = nFAConfiguration.alt;
                continue;
            }
            if (nFAConfiguration.alt == n) continue;
            return -1;
        }
        return n;
    }

    public Set getDisabledAlternatives() {
        LinkedHashSet<Integer> linkedHashSet = new LinkedHashSet<Integer>();
        Iterator iterator = this.nfaConfigurations.iterator();
        while (iterator.hasNext()) {
            NFAConfiguration nFAConfiguration = (NFAConfiguration)iterator.next();
            if (!nFAConfiguration.resolved) continue;
            linkedHashSet.add(Utils.integer(nFAConfiguration.alt));
        }
        return linkedHashSet;
    }

    protected Set getNonDeterministicAlts() {
        int n = this.dfa.getUserMaxLookahead();
        if (n > 0 && n == this.k) {
            return this.getAltSet();
        }
        if (this.abortedDueToMultipleRecursiveAlts || this.abortedDueToRecursionOverflow) {
            return this.getAltSet();
        }
        return this.getConflictingAlts();
    }

    protected Set getConflictingAlts() {
        NFAConfiguration nFAConfiguration;
        int n;
        Integer n2;
        Object object;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (this.nfaConfigurations.size() <= 1) {
            return null;
        }
        Iterator iterator = this.nfaConfigurations.iterator();
        HashMap<Object, ArrayList<NFAConfiguration>> hashMap = new HashMap<Object, ArrayList<NFAConfiguration>>();
        while (iterator.hasNext()) {
            NFAConfiguration nFAConfiguration2 = (NFAConfiguration)iterator.next();
            object = Utils.integer(nFAConfiguration2.state);
            ArrayList<NFAConfiguration> arrayList = (ArrayList<NFAConfiguration>)hashMap.get(object);
            if (arrayList == null) {
                arrayList = new ArrayList<NFAConfiguration>();
                hashMap.put(object, arrayList);
            }
            arrayList.add(nFAConfiguration2);
        }
        object = hashMap.keySet();
        int n3 = 0;
        Iterator<Object> iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            n2 = (Integer)iterator2.next();
            boolean bl = false;
            List list = (List)hashMap.get(n2);
            int n4 = 0;
            for (n = 0; n < list.size() && list.size() > 1; ++n) {
                nFAConfiguration = (NFAConfiguration)list.get(n);
                if (n4 == 0) {
                    n4 = nFAConfiguration.alt;
                    continue;
                }
                if (nFAConfiguration.alt == n4 || this.dfa.nfa.grammar.type == 1 && this.dfa.decisionNFAStartState.enclosingRule.equals("Tokens")) continue;
                ++n3;
                bl = true;
            }
            if (bl) continue;
            hashMap.put(n2, null);
        }
        if (n3 == 0) {
            return null;
        }
        iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            n2 = (Integer)iterator2.next();
            List list = (List)hashMap.get(n2);
            for (int i = 0; list != null && i < list.size(); ++i) {
                NFAConfiguration nFAConfiguration3 = (NFAConfiguration)list.get(i);
                for (n = i + 1; n < list.size(); ++n) {
                    nFAConfiguration = (NFAConfiguration)list.get(n);
                    if (nFAConfiguration3.alt == nFAConfiguration.alt || !nFAConfiguration3.context.conflictsWith(nFAConfiguration.context)) continue;
                    hashSet.add(Utils.integer(nFAConfiguration3.alt));
                    hashSet.add(Utils.integer(nFAConfiguration.alt));
                }
            }
        }
        if (hashSet.size() == 0) {
            return null;
        }
        return hashSet;
    }

    public Set getAltSet() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        Iterator iterator = this.nfaConfigurations.iterator();
        while (iterator.hasNext()) {
            NFAConfiguration nFAConfiguration = (NFAConfiguration)iterator.next();
            hashSet.add(Utils.integer(nFAConfiguration.alt));
        }
        if (hashSet.size() == 0) {
            return null;
        }
        return hashSet;
    }

    public Set getNFAStatesForAlt(int n) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        Iterator iterator = this.nfaConfigurations.iterator();
        while (iterator.hasNext()) {
            NFAConfiguration nFAConfiguration = (NFAConfiguration)iterator.next();
            if (nFAConfiguration.alt != n) continue;
            hashSet.add(Utils.integer(nFAConfiguration.state));
        }
        return hashSet;
    }

    public SemanticContext getGatedPredicatesInNFAConfigurations() {
        Iterator iterator = this.nfaConfigurations.iterator();
        SemanticContext semanticContext = null;
        boolean bl = false;
        while (iterator.hasNext()) {
            NFAConfiguration nFAConfiguration = (NFAConfiguration)iterator.next();
            SemanticContext semanticContext2 = nFAConfiguration.semanticContext.getGatedPredicateContext();
            if (semanticContext2 == null) {
                bl = true;
            }
            if (semanticContext2 == null) continue;
            if (semanticContext == null) {
                semanticContext = semanticContext2;
                continue;
            }
            semanticContext = SemanticContext.or(semanticContext, semanticContext2);
        }
        if (bl) {
            return null;
        }
        if (semanticContext instanceof SemanticContext.TruePredicate) {
            return null;
        }
        return semanticContext;
    }

    public int getAcceptStateReachable() {
        return this.acceptStateReachable;
    }

    public void setAcceptStateReachable(int n) {
        this.acceptStateReachable = n;
    }

    public boolean isResolvedWithPredicates() {
        return this.resolvedWithPredicates;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.stateNumber + ":{");
        Iterator iterator = this.nfaConfigurations.iterator();
        int n = 1;
        while (iterator.hasNext()) {
            NFAConfiguration nFAConfiguration = (NFAConfiguration)iterator.next();
            if (n > 1) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(nFAConfiguration);
            ++n;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public int getLookaheadDepth() {
        return this.k;
    }

    public void setLookaheadDepth(int n) {
        this.k = n;
        if (n > this.dfa.max_k) {
            this.dfa.max_k = n;
        }
    }
}

