/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.codegen;

import java.io.IOException;
import org.antlr.Tool;
import org.antlr.codegen.CodeGenerator;
import org.antlr.codegen.Target;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.tool.Grammar;

public class CPPTarget
extends Target {
    public String escapeChar(int n) {
        switch (n) {
            case 10: {
                return "\\n";
            }
            case 9: {
                return "\\t";
            }
            case 13: {
                return "\\r";
            }
            case 92: {
                return "\\\\";
            }
            case 39: {
                return "\\'";
            }
            case 34: {
                return "\\\"";
            }
        }
        if (n < 32 || n > 126) {
            if (n > 255) {
                String string = Integer.toString(n, 16);
                while (string.length() < 4) {
                    string = '0' + string;
                }
                return "\\u" + string;
            }
            return "\\" + Integer.toString(n, 8);
        }
        return String.valueOf((char)n);
    }

    public String escapeString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append(this.escapeChar(string.charAt(i)));
        }
        return stringBuffer.toString();
    }

    protected void genRecognizerHeaderFile(Tool tool, CodeGenerator codeGenerator, Grammar grammar, StringTemplate stringTemplate) throws IOException {
        StringTemplateGroup stringTemplateGroup = codeGenerator.getTemplates();
        stringTemplateGroup.doNotEmitDebugStringsForTemplate("headerFileExtension");
        String string = stringTemplateGroup.getInstanceOf("headerFileExtension").toString();
        codeGenerator.write(stringTemplate, grammar.name + string);
    }

    public String getTargetCharLiteralFromANTLRCharLiteral(CodeGenerator codeGenerator, String string) {
        int n = Grammar.getCharValueFromGrammarCharLiteral(string);
        String string2 = "'";
        if (codeGenerator.grammar.getMaxCharValue() > 255) {
            string2 = "L'";
        } else if ((n & 0x80) != 0) {
            return "" + n;
        }
        return string2 + this.escapeChar(n) + "'";
    }

    public String getTargetStringLiteralFromANTLRStringLiteral(CodeGenerator codeGenerator, String string) {
        StringBuffer stringBuffer = Grammar.getUnescapedStringFromGrammarStringLiteral(string);
        String string2 = "\"";
        if (codeGenerator.grammar.getMaxCharValue() > 255) {
            string2 = "L\"";
        }
        return string2 + this.escapeString(stringBuffer.toString()) + "\"";
    }

    public int getMaxCharValue(CodeGenerator codeGenerator) {
        int n = 255;
        if (n <= 255) {
            return 255;
        }
        return n;
    }
}

