/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.base.JRBasePrintPage;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.export.Cut;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.Grid;
import net.sf.jasperreports.engine.export.GridRow;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRExporterContext;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporterNature;
import net.sf.jasperreports.engine.export.OccupiedGridCell;
import net.sf.jasperreports.engine.export.ResetableExporterFilter;
import net.sf.jasperreports.engine.export.XlsRowLevelInfo;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.VerticalTextAlignEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.ObjectUtils;
import net.sf.jasperreports.export.ExportInterruptedException;
import net.sf.jasperreports.export.ExporterInputItem;
import net.sf.jasperreports.export.OutputStreamExporterOutput;
import net.sf.jasperreports.export.PrintPartUnrollExporterInput;
import net.sf.jasperreports.export.XlsExporterConfiguration;
import net.sf.jasperreports.export.XlsReportConfiguration;
import net.sf.jasperreports.export.parameters.ParametersOutputStreamExporterOutput;
import net.sf.jasperreports.renderers.RenderersCache;

public abstract class JRXlsAbstractExporter<RC extends XlsReportConfiguration, C extends XlsExporterConfiguration, E extends JRExporterContext>
extends JRAbstractExporter<RC, C, OutputStreamExporterOutput, E> {
    public static final String XLS_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.xls.";
    public static final String DEFAULT_SHEET_NAME_PREFIX = "Page ";
    public static final String DEFAULT_DEFINED_NAME_SCOPE = "workbook";
    public static final String DEFAULT_DEFINED_NAME_SCOPE_SEPARATOR = "\\u007C";
    public static final String EXCEPTION_MESSAGE_KEY_CANNOT_ADD_CELL = "export.xls.common.cannot.add.cell";
    public static final String EXCEPTION_MESSAGE_KEY_CANNOT_MERGE_CELLS = "export.xls.common.cannot.merge.cells";
    public static final String EXCEPTION_MESSAGE_KEY_CELL_FORMAT_TEMPLATE_ERROR = "export.xls.common.cell.format.template.error";
    public static final String EXCEPTION_MESSAGE_KEY_COLUMN_INDEX_BEYOND_LIMIT = "export.xls.common.column.index.beyond.limit";
    public static final String EXCEPTION_MESSAGE_KEY_LOADED_FONTS_ERROR = "export.xls.common.loaded.fonts.error";
    public static final String EXCEPTION_MESSAGE_KEY_NEGATIVE_COLUMN_INDEX = "export.xls.common.negative.column.index";
    public static final String EXCEPTION_MESSAGE_KEY_REPORT_GENERATION_ERROR = "export.xls.common.report.generation.error";
    public static final String EXCEPTION_MESSAGE_KEY_TEMPLATE_NOT_FOUND = "export.xls.common.template.not.found";
    public static final String PROPERTY_CELL_FORMULA = "net.sf.jasperreports.export.xls.formula";
    public static final String PROPERTY_CELL_PATTERN = "net.sf.jasperreports.export.xls.pattern";
    public static final String PROPERTY_SHEET_NAME = "net.sf.jasperreports.export.xls.sheet.name";
    public static final String PROPERTY_WRAP_TEXT = "net.sf.jasperreports.export.xls.wrap.text";
    public static final String PROPERTY_FIT_WIDTH = "net.sf.jasperreports.export.xls.fit.width";
    public static final String PROPERTY_FIT_HEIGHT = "net.sf.jasperreports.export.xls.fit.height";
    public static final String PROPERTY_CELL_LOCKED = "net.sf.jasperreports.export.xls.cell.locked";
    public static final String PROPERTY_CELL_HIDDEN = "net.sf.jasperreports.export.xls.cell.hidden";
    public static final String PROPERTY_SHEET_HEADER_LEFT = "net.sf.jasperreports.export.xls.sheet.header.left";
    public static final String PROPERTY_SHEET_HEADER_CENTER = "net.sf.jasperreports.export.xls.sheet.header.center";
    public static final String PROPERTY_SHEET_HEADER_RIGHT = "net.sf.jasperreports.export.xls.sheet.header.right";
    public static final String PROPERTY_SHEET_FOOTER_LEFT = "net.sf.jasperreports.export.xls.sheet.footer.left";
    public static final String PROPERTY_SHEET_FOOTER_CENTER = "net.sf.jasperreports.export.xls.sheet.footer.center";
    public static final String PROPERTY_SHEET_FOOTER_RIGHT = "net.sf.jasperreports.export.xls.sheet.footer.right";
    public static final String PROPERTY_SHEET_DIRECTION = "net.sf.jasperreports.export.xls.sheet.direction";
    public static final String PROPERTY_FREEZE_ROW = "net.sf.jasperreports.export.xls.freeze.row";
    public static final String PROPERTY_FREEZE_COLUMN = "net.sf.jasperreports.export.xls.freeze.column";
    public static final String PROPERTY_FREEZE_ROW_EDGE = "net.sf.jasperreports.export.xls.freeze.row.edge";
    public static final String PROPERTY_FREEZE_COLUMN_EDGE = "net.sf.jasperreports.export.xls.freeze.column.edge";
    public static final String PROPERTY_AUTO_FIT_ROW = "net.sf.jasperreports.export.xls.auto.fit.row";
    public static final String PROPERTY_AUTO_FIT_COLUMN = "net.sf.jasperreports.export.xls.auto.fit.column";
    public static final String PROPERTY_AUTO_FILTER = "net.sf.jasperreports.export.xls.auto.filter";
    public static final String PROPERTY_COLUMN_WIDTH = "net.sf.jasperreports.export.xls.column.width";
    public static final String PROPERTY_COLUMN_WIDTH_RATIO = "net.sf.jasperreports.export.xls.column.width.ratio";
    public static final String PROPERTY_ROW_OUTLINE_LEVEL_PREFIX = "net.sf.jasperreports.export.xls.row.outline.level.";
    public static final String PROPERTY_USE_TIMEZONE = "net.sf.jasperreports.export.xls.use.timezone";
    public static final String PROPERTY_WORKBOOK_TEMPLATE = "net.sf.jasperreports.export.xls.workbook.template";
    public static final String PROPERTY_WORKBOOK_TEMPLATE_KEEP_SHEETS = "net.sf.jasperreports.export.xls.workbook.template.keep.sheets";
    public static final String PROPERTY_IGNORE_ANCHORS = "net.sf.jasperreports.export.xls.ignore.anchors";
    public static final String PROPERTY_PAGE_SCALE = "net.sf.jasperreports.export.xls.page.scale";
    public static final String PROPERTY_FIRST_PAGE_NUMBER = "net.sf.jasperreports.export.xls.first.page.number";
    public static final String PROPERTY_SHOW_GRIDLINES = "net.sf.jasperreports.export.xls.show.gridlines";
    public static final String PROPERTY_IMAGE_ANCHOR_TYPE = "net.sf.jasperreports.export.xls.image.anchor.type";
    public static final String PROPERTY_IGNORE_HYPERLINK = "net.sf.jasperreports.export.xls.ignore.hyperlink";
    public static final String PROPERTY_BREAK_BEFORE_ROW = "net.sf.jasperreports.export.xls.break.before.row";
    public static final String PROPERTY_BREAK_AFTER_ROW = "net.sf.jasperreports.export.xls.break.after.row";
    protected List<Object> loadedFonts = new ArrayList<Object>();
    protected ExporterNature nature;
    protected String[] sheetNames;
    protected int reportIndex;
    protected int pageIndex;
    protected PrintPageFormat pageFormat;
    protected Map<Integer, Boolean> onePagePerSheetMap = new HashMap<Integer, Boolean>();
    protected int sheetsBeforeCurrentReport;
    protected Map<Integer, Integer> sheetsBeforeCurrentReportMap = new HashMap<Integer, Integer>();
    protected RenderersCache renderersCache;
    protected JRFont defaultFont;
    protected int sheetIndex;
    protected int sheetNamesIndex;
    protected Map<String, Integer> sheetNamesMap;
    protected String autoFilterStart;
    protected String autoFilterEnd;
    protected boolean firstPageNotSet;
    protected Boolean keepTemplateSheets;
    protected String workbookTemplate;
    protected String invalidCharReplacement;
    protected int maxColumnIndex;
    protected SheetInfo sheetInfo;
    protected Map<NameScope, String> definedNamesMap;

    protected JRFont getDefaultFont() {
        return this.defaultFont;
    }

    public JRXlsAbstractExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRXlsAbstractExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
    }

    @Override
    public void exportReport() throws JRException {
        this.ensureJasperReportsContext();
        this.ensureInput();
        this.initExport();
        this.ensureOutput();
        OutputStream outputStream = ((OutputStreamExporterOutput)this.getExporterOutput()).getOutputStream();
        try {
            this.exportReportToStream(outputStream);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
        finally {
            ((OutputStreamExporterOutput)this.getExporterOutput()).close();
            this.resetExportContext();
        }
    }

    @Override
    protected void ensureInput() {
        super.ensureInput();
        this.exporterInput = new PrintPartUnrollExporterInput(this.exporterInput);
        this.jasperPrint = this.exporterInput.getItems().get(0).getJasperPrint();
    }

    @Override
    protected void ensureOutput() {
        if (this.exporterOutput == null) {
            this.exporterOutput = new ParametersOutputStreamExporterOutput(this.getJasperReportsContext(), this.getParameters(), this.getCurrentJasperPrint());
        }
    }

    @Override
    protected void initExport() {
        super.initExport();
        this.sheetIndex = 0;
        this.sheetInfo = null;
        this.onePagePerSheetMap.clear();
        this.sheetsBeforeCurrentReport = 0;
        this.sheetsBeforeCurrentReportMap.clear();
    }

    @Override
    protected void initReport() {
        super.initReport();
        this.setSheetNames();
        this.invalidCharReplacement = this.jasperPrint.hasProperties() && this.jasperPrint.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xml.replace.invalid.chars") ? this.jasperPrint.getProperty("net.sf.jasperreports.export.xml.replace.invalid.chars") : this.getPropertiesUtil().getProperty("net.sf.jasperreports.export.xml.replace.invalid.chars", this.jasperPrint);
        this.renderersCache = new RenderersCache(this.getJasperReportsContext());
    }

    protected void exportReportToStream(OutputStream os) throws JRException, IOException {
        this.openWorkbook(os);
        this.sheetNamesMap = new HashMap<String, Integer>();
        this.definedNamesMap = new HashMap<NameScope, String>();
        this.pageFormat = null;
        boolean pageExported = false;
        List<ExporterInputItem> items = this.exporterInput.getItems();
        this.reportIndex = 0;
        while (this.reportIndex < items.size()) {
            ExporterInputItem item = items.get(this.reportIndex);
            this.setCurrentExporterInputItem(item);
            this.defaultFont = new JRBasePrintText(this.jasperPrint.getDefaultStyleProvider());
            if (!this.hasGlobalSheetNames()) {
                this.sheetNamesIndex = 0;
            }
            XlsReportConfiguration configuration = (XlsReportConfiguration)this.getCurrentItemConfiguration();
            this.configureDefinedNames(configuration.getDefinedNames());
            List<JRPrintPage> pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                int endPageIndex;
                JRAbstractExporter.PageRange pageRange = this.getPageRange();
                int startPageIndex = pageRange == null || pageRange.getStartPageIndex() == null ? 0 : pageRange.getStartPageIndex();
                int n = endPageIndex = pageRange == null || pageRange.getEndPageIndex() == null ? pages.size() - 1 : pageRange.getEndPageIndex();
                if (configuration.isOnePagePerSheet().booleanValue()) {
                    this.pageIndex = startPageIndex;
                    while (this.pageIndex <= endPageIndex) {
                        if (Thread.interrupted()) {
                            throw new ExportInterruptedException();
                        }
                        JRPrintPage page = pages.get(this.pageIndex);
                        this.pageFormat = this.jasperPrint.getPageFormat(this.pageIndex);
                        this.exportPage(page, null, 0, null);
                        ++this.pageIndex;
                    }
                } else {
                    CutsInfo xCuts = JRGridLayout.calculateXCuts(this.getNature(), this.jasperPrint, startPageIndex, endPageIndex, configuration.getOffsetX() == null ? 0 : configuration.getOffsetX());
                    if (this.filter instanceof ResetableExporterFilter) {
                        ((ResetableExporterFilter)this.filter).reset();
                    }
                    int startRow = 0;
                    this.pageIndex = startPageIndex;
                    while (this.pageIndex <= endPageIndex) {
                        if (Thread.interrupted()) {
                            throw new ExportInterruptedException();
                        }
                        JRPrintPage page = pages.get(this.pageIndex);
                        this.pageFormat = this.jasperPrint.getPageFormat(this.pageIndex);
                        startRow = this.exportPage(page, xCuts, startRow, this.jasperPrint.getName());
                        ++this.pageIndex;
                    }
                }
                pageExported = true;
            } else if (this.reportIndex == items.size() - 1 && !pageExported) {
                this.exportEmptyReport();
            }
            this.sheetsBeforeCurrentReport = configuration.isOnePagePerSheet() != false ? this.sheetIndex : this.sheetsBeforeCurrentReport + 1;
            ++this.reportIndex;
        }
        this.closeSheet();
        this.closeWorkbook(os);
    }

    protected int exportPage(JRPrintPage page, CutsInfo xCuts, int startRow, String defaultSheetName) throws JRException {
        boolean createXCuts;
        XlsReportConfiguration configuration = (XlsReportConfiguration)this.getCurrentItemConfiguration();
        int maxRowsPerSheet = this.getMaxRowsPerSheet();
        boolean isRemoveEmptySpaceBetweenRows = configuration.isRemoveEmptySpaceBetweenRows();
        boolean isRemoveEmptySpaceBetweenColumns = configuration.isRemoveEmptySpaceBetweenColumns();
        boolean isCollapseRowSpan = configuration.isCollapseRowSpan();
        JRGridLayout layout = new JRGridLayout(this.getNature(), page.getElements(), (int)this.pageFormat.getPageWidth(), (int)this.pageFormat.getPageHeight(), configuration.getOffsetX() == null ? 0 : configuration.getOffsetX(), configuration.getOffsetY() == null ? 0 : configuration.getOffsetY(), xCuts);
        Grid grid = layout.getGrid();
        boolean bl = createXCuts = xCuts == null;
        if (createXCuts) {
            xCuts = layout.getXCuts();
        }
        CutsInfo yCuts = layout.getYCuts();
        if (createXCuts || startRow == 0) {
            this.exportSheet(xCuts, yCuts, 0, defaultSheetName);
        }
        XlsRowLevelInfo levelInfo = new XlsRowLevelInfo();
        int skippedRows = 0;
        int rowIndex = startRow;
        int rowCount = grid.getRowCount();
        for (int y = 0; y < rowCount; ++y) {
            Cut yCut = yCuts.getCut(y);
            rowIndex = y - skippedRows + startRow;
            if (maxRowsPerSheet > 0 && rowIndex >= maxRowsPerSheet || yCut.isBreak()) {
                this.setRowLevels(levelInfo, null);
                this.exportSheet(xCuts, yCuts, y, defaultSheetName);
                startRow = 0;
                rowIndex = 0;
                skippedRows = y;
            }
            if (yCut.isCutNotEmpty() || (!isRemoveEmptySpaceBetweenRows || yCut.isCutSpanned()) && !isCollapseRowSpan) {
                GridRow gridRow = grid.getRow(y);
                int emptyCellColSpan = 0;
                this.mergeAndSetRowLevels(levelInfo, (SortedMap)yCut.getProperty(PROPERTY_ROW_OUTLINE_LEVEL_PREFIX), rowIndex);
                this.setRowHeight(rowIndex, isCollapseRowSpan ? layout.getMaxRowHeight(y) : JRGridLayout.getRowHeight(gridRow), yCuts.getCut(y), levelInfo);
                int emptyCols = 0;
                int rowSize = gridRow.size();
                for (int xCutIndex = 0; xCutIndex < rowSize; ++xCutIndex) {
                    Cut xCut = xCuts.getCut(xCutIndex);
                    boolean isEmptyCol = !xCut.isCutNotEmpty() && !xCut.isCutSpanned();
                    int colIndex = xCutIndex - (emptyCols += isRemoveEmptySpaceBetweenColumns && isEmptyCol ? 1 : 0);
                    if (colIndex > this.maxColumnIndex) {
                        throw new JRException(EXCEPTION_MESSAGE_KEY_COLUMN_INDEX_BEYOND_LIMIT, new Object[]{colIndex, this.maxColumnIndex});
                    }
                    JRExporterGridCell gridCell = gridRow.get(xCutIndex);
                    if (gridCell.getType() == 2) {
                        if (emptyCellColSpan > 0) {
                            emptyCellColSpan = 0;
                        }
                        this.addOccupiedCell((OccupiedGridCell)gridCell, colIndex, rowIndex);
                        continue;
                    }
                    if (gridCell.getType() == 3) {
                        if (emptyCellColSpan > 0) {
                            emptyCellColSpan = 0;
                        }
                        JRPrintElement element = gridCell.getElement();
                        String autofilter = this.getPropertiesUtil().getProperty(element, PROPERTY_AUTO_FILTER);
                        if ("Start".equals(autofilter)) {
                            this.autoFilterStart = "$" + JRStringUtil.getLetterNumeral(colIndex + 1, true) + "$" + (rowIndex + 1);
                        } else if ("End".equals(autofilter)) {
                            this.autoFilterEnd = "$" + JRStringUtil.getLetterNumeral(colIndex + 1, true) + "$" + (rowIndex + 1);
                        }
                        this.configureDefinedNames(this.getNature(), element);
                        if (element instanceof JRPrintLine) {
                            this.exportLine((JRPrintLine)element, gridCell, colIndex, rowIndex);
                            continue;
                        }
                        if (element instanceof JRPrintRectangle) {
                            this.exportRectangle((JRPrintRectangle)element, gridCell, colIndex, rowIndex);
                            continue;
                        }
                        if (element instanceof JRPrintEllipse) {
                            this.exportRectangle((JRPrintEllipse)element, gridCell, colIndex, rowIndex);
                            continue;
                        }
                        if (element instanceof JRPrintImage) {
                            this.exportImage((JRPrintImage)element, gridCell, colIndex, rowIndex, emptyCols, y, layout);
                            continue;
                        }
                        if (element instanceof JRPrintText) {
                            this.exportText((JRPrintText)element, gridCell, colIndex, rowIndex);
                            continue;
                        }
                        if (element instanceof JRPrintFrame) {
                            this.exportFrame((JRPrintFrame)element, gridCell, colIndex, y);
                            continue;
                        }
                        if (!(element instanceof JRGenericPrintElement)) continue;
                        this.exportGenericElement((JRGenericPrintElement)element, gridCell, colIndex, rowIndex, emptyCols, y, layout);
                        continue;
                    }
                    ++emptyCellColSpan;
                    if (isRemoveEmptySpaceBetweenColumns && isEmptyCol) continue;
                    this.addBlankCell(gridCell, colIndex, rowIndex);
                }
                ++rowIndex;
                continue;
            }
            ++skippedRows;
        }
        if (configuration.isForcePageBreaks().booleanValue()) {
            this.addRowBreak(rowCount - skippedRows + startRow - 1);
        }
        if (this.autoFilterStart != null) {
            this.setAutoFilter(this.autoFilterStart + ":" + (this.autoFilterEnd != null ? this.autoFilterEnd : this.autoFilterStart));
        } else if (this.autoFilterEnd != null) {
            this.setAutoFilter(this.autoFilterEnd + ":" + this.autoFilterEnd);
        }
        this.setRowLevels(levelInfo, null);
        JRExportProgressMonitor progressMonitor = configuration.getProgressMonitor();
        if (progressMonitor != null) {
            progressMonitor.afterPageExport();
        }
        return rowIndex;
    }

    protected SheetInfo getSheetProps(CutsInfo xCuts, CutsInfo yCuts, int startCutIndex) {
        SheetInfo sheetInfo = new SheetInfo();
        XlsReportConfiguration configuration = (XlsReportConfiguration)this.getCurrentItemConfiguration();
        int maxRowsPerSheet = this.getMaxRowsPerSheet();
        boolean isRemoveEmptySpaceBetweenRows = configuration.isRemoveEmptySpaceBetweenRows();
        boolean isCollapseRowSpan = configuration.isCollapseRowSpan();
        sheetInfo.tabColor = configuration.getSheetTabColor();
        sheetInfo.ignoreCellBackground = configuration.isIgnoreCellBackground();
        sheetInfo.whitePageBackground = configuration.isWhitePageBackground();
        sheetInfo.ignoreCellBorder = configuration.isIgnoreCellBorder();
        boolean elementLevelRowFreeze = false;
        boolean elementLevelColumnFreeze = false;
        sheetInfo.rowFreezeIndex = configuration.getFreezeRow() == null ? -1 : Math.max(0, configuration.getFreezeRow() - 1);
        sheetInfo.columnFreezeIndex = configuration.getFreezeColumn() == null ? -1 : Math.max(0, this.getColumnIndex(configuration.getFreezeColumn()));
        sheetInfo.printSettings = new SheetInfo().new SheetInfo.SheetPrintSettings();
        int skippedRows = 0;
        int rowIndex = 0;
        int rowCount = yCuts.size() - 1;
        for (int y = startCutIndex; y < rowCount; ++y) {
            Cut yCut = yCuts.getCut(y);
            rowIndex = y - skippedRows;
            if (y > startCutIndex && (maxRowsPerSheet > 0 && rowIndex >= maxRowsPerSheet || yCut.isBreak())) break;
            if (yCut.isCutNotEmpty() || (!isRemoveEmptySpaceBetweenRows || yCut.isCutSpanned()) && !isCollapseRowSpan) {
                Integer freezeRow;
                Integer pageScale;
                Boolean whitePageBackground;
                Boolean ignoreCellBorder;
                Boolean ignoreCellBackground;
                Boolean showGridlines;
                Integer firstPageNumber;
                String color;
                Color tabColor;
                Float sheetRatio;
                String sheetName = (String)yCut.getProperty(PROPERTY_SHEET_NAME);
                if (sheetName != null) {
                    sheetInfo.sheetName = sheetName;
                }
                if ((sheetRatio = (Float)yCut.getProperty(PROPERTY_COLUMN_WIDTH_RATIO)) != null && (sheetInfo.columnWidthRatio == null || sheetInfo.columnWidthRatio.floatValue() < sheetRatio.floatValue())) {
                    sheetInfo.columnWidthRatio = sheetRatio;
                }
                if ((tabColor = JRColorUtil.getColor(color = (String)yCut.getProperty("net.sf.jasperreports.export.xls.sheet.tab.color"), null)) != null) {
                    sheetInfo.tabColor = tabColor;
                }
                if ((firstPageNumber = (Integer)yCut.getProperty(PROPERTY_FIRST_PAGE_NUMBER)) != null) {
                    sheetInfo.sheetFirstPageNumber = firstPageNumber;
                }
                if ((showGridlines = (Boolean)yCut.getProperty(PROPERTY_SHOW_GRIDLINES)) != null) {
                    sheetInfo.sheetShowGridlines = showGridlines;
                }
                if ((ignoreCellBackground = (Boolean)yCut.getProperty("net.sf.jasperreports.export.xls.ignore.cell.background")) != null) {
                    sheetInfo.ignoreCellBackground = ignoreCellBackground;
                }
                if ((ignoreCellBorder = (Boolean)yCut.getProperty("net.sf.jasperreports.export.xls.ignore.cell.border")) != null) {
                    sheetInfo.ignoreCellBorder = ignoreCellBorder;
                }
                if ((whitePageBackground = (Boolean)yCut.getProperty("net.sf.jasperreports.export.xls.white.page.background")) != null) {
                    sheetInfo.whitePageBackground = whitePageBackground;
                }
                sheetInfo.sheetPageScale = this.isValidScale(pageScale = (Integer)yCut.getProperty(PROPERTY_PAGE_SCALE)) ? pageScale : configuration.getPageScale();
                Integer freezeColumn = (Integer)yCut.getProperty(PROPERTY_FREEZE_COLUMN_EDGE);
                if (!(freezeColumn == null || elementLevelColumnFreeze && freezeColumn <= sheetInfo.columnFreezeIndex)) {
                    sheetInfo.columnFreezeIndex = Math.max(0, freezeColumn);
                    elementLevelColumnFreeze = true;
                }
                if (!((freezeRow = (Integer)yCut.getProperty(PROPERTY_FREEZE_ROW_EDGE)) == null || elementLevelRowFreeze && freezeRow <= sheetInfo.rowFreezeIndex)) {
                    sheetInfo.rowFreezeIndex = Math.max(0, freezeRow);
                    elementLevelRowFreeze = true;
                }
                sheetInfo.sheetPageScale = this.isValidScale(pageScale) ? pageScale : configuration.getPageScale();
                this.configurePrintSettings(sheetInfo.printSettings, yCut);
                this.configureHeaderFooter(sheetInfo.printSettings, yCut);
                ++rowIndex;
                continue;
            }
            ++skippedRows;
        }
        this.updatePrintSettings(sheetInfo.printSettings, configuration);
        this.updateHeaderFooter(sheetInfo.printSettings, configuration);
        return sheetInfo;
    }

    protected void configurePrintSettings(SheetInfo.SheetPrintSettings printSettings, Cut yCut) {
        Integer value = null;
        if (yCut.hasProperty("net.sf.jasperreports.export.xls.print.page.height")) {
            value = (Integer)yCut.getProperty("net.sf.jasperreports.export.xls.print.page.height");
            if (printSettings.getPageHeight() == null || printSettings.getPageHeight() < value) {
                printSettings.setPageHeight(value);
            }
        }
        if (yCut.hasProperty("net.sf.jasperreports.export.xls.print.page.width")) {
            value = (Integer)yCut.getProperty("net.sf.jasperreports.export.xls.print.page.width");
            if (printSettings.getPageWidth() == null || printSettings.getPageWidth() < value) {
                printSettings.setPageWidth(value);
            }
        }
        if (yCut.hasProperty("net.sf.jasperreports.export.xls.print.page.top.margin")) {
            value = (Integer)yCut.getProperty("net.sf.jasperreports.export.xls.print.page.top.margin");
            if (printSettings.getTopMargin() == null || printSettings.getTopMargin() < value) {
                printSettings.setTopMargin(value);
            }
        }
        if (yCut.hasProperty("net.sf.jasperreports.export.xls.print.page.left.margin")) {
            value = (Integer)yCut.getProperty("net.sf.jasperreports.export.xls.print.page.left.margin");
            if (printSettings.getLeftMargin() == null || printSettings.getLeftMargin() < value) {
                printSettings.setLeftMargin(value);
            }
        }
        if (yCut.hasProperty("net.sf.jasperreports.export.xls.print.page.bottom.margin")) {
            value = (Integer)yCut.getProperty("net.sf.jasperreports.export.xls.print.page.bottom.margin");
            if (printSettings.getBottomMargin() == null || printSettings.getBottomMargin() < value) {
                printSettings.setBottomMargin((Integer)yCut.getProperty("net.sf.jasperreports.export.xls.print.page.bottom.margin"));
            }
        }
        if (yCut.hasProperty("net.sf.jasperreports.export.xls.print.page.right.margin")) {
            value = (Integer)yCut.getProperty("net.sf.jasperreports.export.xls.print.page.right.margin");
            if (printSettings.getRightMargin() == null || printSettings.getRightMargin() < value) {
                printSettings.setRightMargin((Integer)yCut.getProperty("net.sf.jasperreports.export.xls.print.page.right.margin"));
            }
        }
        if (yCut.hasProperty("net.sf.jasperreports.export.xls.print.header.margin")) {
            value = (Integer)yCut.getProperty("net.sf.jasperreports.export.xls.print.header.margin");
            if (printSettings.getHeaderMargin() == null || printSettings.getHeaderMargin() < value) {
                printSettings.setHeaderMargin((Integer)yCut.getProperty("net.sf.jasperreports.export.xls.print.header.margin"));
            }
        }
        if (yCut.hasProperty("net.sf.jasperreports.export.xls.print.footer.margin")) {
            value = (Integer)yCut.getProperty("net.sf.jasperreports.export.xls.print.footer.margin");
            if (printSettings.getFooterMargin() == null || printSettings.getFooterMargin() < value) {
                printSettings.setFooterMargin((Integer)yCut.getProperty("net.sf.jasperreports.export.xls.print.footer.margin"));
            }
        }
    }

    protected void updatePrintSettings(SheetInfo.SheetPrintSettings printSettings, XlsReportConfiguration configuration) {
        if (printSettings.getPageHeight() == null) {
            printSettings.setPageHeight(configuration.getPrintPageHeight() == null ? this.jasperPrint.getPageHeight() : configuration.getPrintPageHeight().intValue());
        }
        if (printSettings.getPageWidth() == null) {
            printSettings.setPageWidth(configuration.getPrintPageWidth() == null ? this.jasperPrint.getPageWidth() : configuration.getPrintPageWidth().intValue());
        }
        if (printSettings.getTopMargin() == null) {
            printSettings.setTopMargin(configuration.getPrintPageTopMargin() == null ? 0 : configuration.getPrintPageTopMargin());
        }
        if (printSettings.getLeftMargin() == null) {
            printSettings.setLeftMargin(configuration.getPrintPageLeftMargin() == null ? 0 : configuration.getPrintPageLeftMargin());
        }
        if (printSettings.getBottomMargin() == null) {
            printSettings.setBottomMargin(configuration.getPrintPageBottomMargin() == null ? 0 : configuration.getPrintPageBottomMargin());
        }
        if (printSettings.getRightMargin() == null) {
            printSettings.setRightMargin(configuration.getPrintPageRightMargin() == null ? 0 : configuration.getPrintPageRightMargin());
        }
        if (printSettings.getHeaderMargin() == null) {
            printSettings.setHeaderMargin(configuration.getPrintHeaderMargin() == null ? 0 : configuration.getPrintHeaderMargin());
        }
        if (printSettings.getFooterMargin() == null) {
            printSettings.setFooterMargin(configuration.getPrintFooterMargin() == null ? 0 : configuration.getPrintFooterMargin());
        }
    }

    protected void configureHeaderFooter(SheetInfo.SheetPrintSettings printSettings, Cut yCut) {
        if (yCut.hasProperty(PROPERTY_SHEET_HEADER_LEFT)) {
            printSettings.setHeaderLeft((String)yCut.getProperty(PROPERTY_SHEET_HEADER_LEFT));
        }
        if (yCut.hasProperty(PROPERTY_SHEET_HEADER_CENTER)) {
            printSettings.setHeaderCenter((String)yCut.getProperty(PROPERTY_SHEET_HEADER_CENTER));
        }
        if (yCut.hasProperty(PROPERTY_SHEET_HEADER_RIGHT)) {
            printSettings.setHeaderRight((String)yCut.getProperty(PROPERTY_SHEET_HEADER_RIGHT));
        }
        if (yCut.hasProperty(PROPERTY_SHEET_FOOTER_LEFT)) {
            printSettings.setFooterLeft((String)yCut.getProperty(PROPERTY_SHEET_FOOTER_LEFT));
        }
        if (yCut.hasProperty(PROPERTY_SHEET_FOOTER_CENTER)) {
            printSettings.setFooterCenter((String)yCut.getProperty(PROPERTY_SHEET_FOOTER_CENTER));
        }
        if (yCut.hasProperty(PROPERTY_SHEET_FOOTER_RIGHT)) {
            printSettings.setFooterRight((String)yCut.getProperty(PROPERTY_SHEET_FOOTER_RIGHT));
        }
    }

    protected void updateHeaderFooter(SheetInfo.SheetPrintSettings printSettings, XlsReportConfiguration configuration) {
        if (printSettings.getHeaderLeft() == null) {
            printSettings.setHeaderLeft(configuration.getSheetHeaderLeft());
        }
        if (printSettings.getHeaderCenter() == null) {
            printSettings.setHeaderCenter(configuration.getSheetHeaderCenter());
        }
        if (printSettings.getHeaderRight() == null) {
            printSettings.setHeaderRight(configuration.getSheetHeaderRight());
        }
        if (printSettings.getFooterLeft() == null) {
            printSettings.setFooterLeft(configuration.getSheetFooterLeft());
        }
        if (printSettings.getFooterCenter() == null) {
            printSettings.setFooterCenter(configuration.getSheetFooterCenter());
        }
        if (printSettings.getFooterRight() == null) {
            printSettings.setFooterRight(configuration.getSheetFooterRight());
        }
    }

    protected void exportSheet(CutsInfo xCuts, CutsInfo yCuts, int startCutIndex, String defaultSheetName) {
        if (this.sheetInfo != null) {
            this.closeSheet();
        }
        this.sheetInfo = this.getSheetProps(xCuts, yCuts, startCutIndex);
        this.sheetInfo.sheetName = this.getSheetName(this.sheetInfo.sheetName, defaultSheetName);
        this.sheetInfo.sheetFirstPageIndex = this.pageIndex;
        this.createSheet(xCuts, this.sheetInfo);
        ++this.sheetIndex;
        ++this.sheetNamesIndex;
        this.resetAutoFilters();
        this.setFreezePane(this.sheetInfo.rowFreezeIndex, this.sheetInfo.columnFreezeIndex);
        this.setColumnWidths(xCuts);
    }

    protected void mergeAndSetRowLevels(XlsRowLevelInfo levelInfo, SortedMap<String, Boolean> rowLevelMap, int rowIndex) {
        if (rowLevelMap != null) {
            SortedMap<String, Integer> crtLevelMap = levelInfo.getLevelMap();
            for (String level : rowLevelMap.keySet()) {
                Iterator<String> it;
                Boolean isEndMarker = (Boolean)rowLevelMap.get(level);
                if (crtLevelMap.containsKey(level)) {
                    if (!isEndMarker.booleanValue()) continue;
                    this.setRowLevels(levelInfo, level);
                    it = crtLevelMap.keySet().iterator();
                    while (it.hasNext()) {
                        if (level.compareTo(it.next()) > 0) continue;
                        it.remove();
                    }
                    continue;
                }
                if (crtLevelMap.size() > 0 && level.compareTo(crtLevelMap.firstKey()) < 0) {
                    this.setRowLevels(levelInfo, level);
                    it = crtLevelMap.keySet().iterator();
                    while (it.hasNext()) {
                        if (level.compareTo(it.next()) >= 0) continue;
                        it.remove();
                    }
                }
                crtLevelMap.put(level, rowIndex);
            }
        }
        levelInfo.setEndIndex(rowIndex);
    }

    protected void setColumnWidths(CutsInfo xCuts) {
        XlsReportConfiguration configuration = (XlsReportConfiguration)this.getCurrentItemConfiguration();
        boolean isRemoveEmptySpaceBetweenColumns = configuration.isRemoveEmptySpaceBetweenColumns();
        float sheetRatio = this.sheetInfo.columnWidthRatio == null ? (configuration.getColumnWidthRatio() == null ? 1.0f : configuration.getColumnWidthRatio().floatValue()) : this.sheetInfo.columnWidthRatio.floatValue();
        sheetRatio = Math.max(1.0f, sheetRatio);
        int emptyCols = 0;
        for (int xCutIndex = 0; xCutIndex < xCuts.size() - 1; ++xCutIndex) {
            Cut xCut = xCuts.getCut(xCutIndex);
            if (!isRemoveEmptySpaceBetweenColumns || xCut.isCutNotEmpty() || xCut.isCutSpanned()) {
                Integer width = (Integer)xCut.getProperty(PROPERTY_COLUMN_WIDTH);
                width = width == null ? (int)((float)(xCuts.getCutOffset(xCutIndex + 1) - xCuts.getCutOffset(xCutIndex)) * sheetRatio) : width;
                boolean isAutoFit = xCut.hasProperty(PROPERTY_AUTO_FIT_COLUMN) && (Boolean)xCut.getProperty(PROPERTY_AUTO_FIT_COLUMN) != false;
                this.setColumnWidth(xCutIndex - emptyCols, width, isAutoFit);
                continue;
            }
            ++emptyCols;
        }
    }

    @Override
    protected JRStyledText getStyledText(JRPrintText textElement) {
        JRStyledTextAttributeSelector selector = textElement.getModeValue() == ModeEnum.OPAQUE ? this.allSelector : this.noBackcolorSelector;
        return textElement.getFullStyledText(selector);
    }

    public static TextAlignHolder getTextAlignHolder(JRPrintText textElement) {
        HorizontalTextAlignEnum horizontalAlignment;
        VerticalTextAlignEnum verticalAlignment;
        RotationEnum rotation = textElement.getRotationValue();
        block0 : switch (textElement.getRotationValue()) {
            case LEFT: {
                switch (textElement.getHorizontalTextAlign()) {
                    case JUSTIFIED: {
                        verticalAlignment = VerticalTextAlignEnum.JUSTIFIED;
                        break;
                    }
                    case RIGHT: {
                        verticalAlignment = VerticalTextAlignEnum.TOP;
                        break;
                    }
                    case CENTER: {
                        verticalAlignment = VerticalTextAlignEnum.MIDDLE;
                        break;
                    }
                    default: {
                        verticalAlignment = VerticalTextAlignEnum.BOTTOM;
                    }
                }
                switch (textElement.getVerticalTextAlign()) {
                    case JUSTIFIED: {
                        horizontalAlignment = HorizontalTextAlignEnum.JUSTIFIED;
                        break block0;
                    }
                    case BOTTOM: {
                        horizontalAlignment = HorizontalTextAlignEnum.RIGHT;
                        break block0;
                    }
                    case MIDDLE: {
                        horizontalAlignment = HorizontalTextAlignEnum.CENTER;
                        break block0;
                    }
                }
                horizontalAlignment = HorizontalTextAlignEnum.LEFT;
                break;
            }
            case RIGHT: {
                switch (textElement.getHorizontalTextAlign()) {
                    case JUSTIFIED: {
                        verticalAlignment = VerticalTextAlignEnum.JUSTIFIED;
                        break;
                    }
                    case RIGHT: {
                        verticalAlignment = VerticalTextAlignEnum.BOTTOM;
                        break;
                    }
                    case CENTER: {
                        verticalAlignment = VerticalTextAlignEnum.MIDDLE;
                        break;
                    }
                    default: {
                        verticalAlignment = VerticalTextAlignEnum.TOP;
                    }
                }
                switch (textElement.getVerticalTextAlign()) {
                    case JUSTIFIED: {
                        horizontalAlignment = HorizontalTextAlignEnum.JUSTIFIED;
                        break block0;
                    }
                    case BOTTOM: {
                        horizontalAlignment = HorizontalTextAlignEnum.LEFT;
                        break block0;
                    }
                    case MIDDLE: {
                        horizontalAlignment = HorizontalTextAlignEnum.CENTER;
                        break block0;
                    }
                }
                horizontalAlignment = HorizontalTextAlignEnum.RIGHT;
                break;
            }
            default: {
                horizontalAlignment = textElement.getHorizontalTextAlign();
                verticalAlignment = textElement.getVerticalTextAlign();
            }
        }
        return new TextAlignHolder(horizontalAlignment, verticalAlignment, rotation);
    }

    protected int getImageBorderCorrection(JRPen pen) {
        float lineWidth = pen.getLineWidth().floatValue();
        if (lineWidth > 0.0f) {
            if (lineWidth >= 2.0f) {
                return 2;
            }
            return 1;
        }
        return ((XlsReportConfiguration)this.getCurrentItemConfiguration()).isImageBorderFixEnabled() != false ? 1 : 0;
    }

    private String getSheetName(String sheetName, String defaultSheetName) {
        if (sheetName != null) {
            if (this.sheetNames != null && this.sheetNamesIndex < this.sheetNames.length) {
                this.sheetNames[this.sheetNamesIndex] = sheetName;
            }
            return this.getSheetName(sheetName);
        }
        return this.getSheetName(defaultSheetName);
    }

    private String getSheetName(String sheetName) {
        String validSheetName;
        if (this.sheetNames != null && this.sheetNamesIndex < this.sheetNames.length) {
            sheetName = this.sheetNames[this.sheetNamesIndex];
        }
        if (sheetName == null) {
            return DEFAULT_SHEET_NAME_PREFIX + (this.sheetIndex + 1);
        }
        int crtIndex = 1;
        String txtIndex = "";
        String string = validSheetName = sheetName.length() < 32 ? sheetName : sheetName.substring(0, 31);
        if (this.sheetNamesMap.containsKey(validSheetName)) {
            crtIndex = this.sheetNamesMap.get(validSheetName) + 1;
            txtIndex = String.valueOf(crtIndex);
        }
        this.sheetNamesMap.put(validSheetName, crtIndex);
        String name = sheetName;
        if (txtIndex.length() > 0) {
            name = name + " " + txtIndex;
        }
        if (name.length() > 31) {
            name = (sheetName + " ").substring(0, 31 - txtIndex.length()) + txtIndex;
        }
        return name;
    }

    protected final int calculateWidthForDinAN(int n) {
        return (int)(Math.pow(2.0, -0.25 - (double)n / 2.0) * 1000.0);
    }

    protected final int calculateHeightForDinAN(int n) {
        return (int)(Math.pow(2.0, 0.25 - (double)n / 2.0) * 1000.0);
    }

    protected final int calculateWidthForDinBN(int n) {
        return (int)(Math.pow(2.0, -((double)n / 2.0)) * 1000.0);
    }

    protected final int calculateHeightForDinBN(int n) {
        return (int)(Math.pow(2.0, 0.5 - (double)n / 2.0) * 1000.0);
    }

    protected final int calculateWidthForDinCN(int n) {
        return (int)(Math.pow(2.0, -0.125 - (double)n / 2.0) * 1000.0);
    }

    protected final int calculateHeightForDinCN(int n) {
        return (int)(Math.pow(2.0, 0.375 - (double)n / 2.0) * 1000.0);
    }

    protected boolean isWrapText(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty(PROPERTY_WRAP_TEXT)) {
            return this.getPropertiesUtil().getBooleanProperty(element, PROPERTY_WRAP_TEXT, (boolean)((XlsReportConfiguration)this.getCurrentItemConfiguration()).isWrapText());
        }
        return ((XlsReportConfiguration)this.getCurrentItemConfiguration()).isWrapText();
    }

    protected boolean isCellLocked(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty(PROPERTY_CELL_LOCKED)) {
            return this.getPropertiesUtil().getBooleanProperty(element, PROPERTY_CELL_LOCKED, (boolean)((XlsReportConfiguration)this.getCurrentItemConfiguration()).isCellLocked());
        }
        return ((XlsReportConfiguration)this.getCurrentItemConfiguration()).isCellLocked();
    }

    protected boolean isShrinkToFit(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.shrink.to.fit")) {
            return this.getPropertiesUtil().getBooleanProperty(element, "net.sf.jasperreports.export.xls.shrink.to.fit", (boolean)((XlsReportConfiguration)this.getCurrentItemConfiguration()).isShrinkToFit());
        }
        return ((XlsReportConfiguration)this.getCurrentItemConfiguration()).isShrinkToFit();
    }

    protected boolean isIgnoreTextFormatting(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.ignore.text.formatting")) {
            return this.getPropertiesUtil().getBooleanProperty(element, "net.sf.jasperreports.export.xls.ignore.text.formatting", (boolean)((XlsReportConfiguration)this.getCurrentItemConfiguration()).isIgnoreTextFormatting());
        }
        return ((XlsReportConfiguration)this.getCurrentItemConfiguration()).isIgnoreTextFormatting();
    }

    protected String getFormula(JRPrintText text) {
        String formula = JRPropertiesUtil.getOwnProperty(text, PROPERTY_CELL_FORMULA);
        if (formula != null && (formula = formula.trim()).startsWith("=")) {
            formula = formula.substring(1);
        }
        return formula;
    }

    protected void setSheetNames() {
        String[] sheetNamesArray = ((XlsReportConfiguration)this.getCurrentItemConfiguration()).getSheetNames();
        List<String> sheetNamesList = JRStringUtil.split(sheetNamesArray, "/");
        this.sheetNames = sheetNamesList == null ? null : sheetNamesList.toArray(new String[sheetNamesList.size()]);
    }

    protected boolean hasGlobalSheetNames() {
        XlsReportConfiguration lcItemConfiguration;
        Boolean globalSheetNames = null;
        boolean isOverrideHintsDefault = this.propertiesUtil.getBooleanProperty("net.sf.jasperreports.export.configuration.override.report.hints");
        if (this.itemConfiguration != null && ((XlsReportConfiguration)this.itemConfiguration).getSheetNames() != null) {
            boolean isExporterConfigOverrideHints;
            boolean bl = isExporterConfigOverrideHints = ((XlsReportConfiguration)this.itemConfiguration).isOverrideHints() == null ? isOverrideHintsDefault : ((XlsReportConfiguration)this.itemConfiguration).isOverrideHints();
            if (isExporterConfigOverrideHints) {
                globalSheetNames = true;
            }
        }
        if (globalSheetNames == null && (lcItemConfiguration = (XlsReportConfiguration)this.crtItem.getConfiguration()) != null && lcItemConfiguration.getSheetNames() != null) {
            boolean isItemConfigOverrideHints;
            boolean bl = isItemConfigOverrideHints = lcItemConfiguration.isOverrideHints() == null ? isOverrideHintsDefault : lcItemConfiguration.isOverrideHints();
            if (isItemConfigOverrideHints) {
                globalSheetNames = false;
            }
        }
        if (globalSheetNames == null) {
            List<JRPropertiesUtil.PropertySuffix> properties = JRPropertiesUtil.getProperties(this.getCurrentJasperPrint(), "net.sf.jasperreports.export.xls.sheet.names.");
            globalSheetNames = properties == null || properties.isEmpty();
        }
        return globalSheetNames;
    }

    protected boolean isCellHidden(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty(PROPERTY_CELL_HIDDEN)) {
            return this.getPropertiesUtil().getBooleanProperty(element, PROPERTY_CELL_HIDDEN, (boolean)((XlsReportConfiguration)this.getCurrentItemConfiguration()).isCellHidden());
        }
        return ((XlsReportConfiguration)this.getCurrentItemConfiguration()).isCellHidden();
    }

    protected String getConvertedPattern(JRPrintText text, String pattern) {
        String convertedPattern = JRPropertiesUtil.getOwnProperty(text, PROPERTY_CELL_PATTERN);
        if (convertedPattern == null || convertedPattern.trim().length() == 0) {
            Map<String, String> formatPatternsMap = ((XlsReportConfiguration)this.getCurrentItemConfiguration()).getFormatPatternsMap();
            if (formatPatternsMap != null && formatPatternsMap.containsKey(pattern)) {
                return formatPatternsMap.get(pattern);
            }
            return pattern == null || pattern.trim().length() == 0 ? null : pattern;
        }
        return convertedPattern;
    }

    protected int getColumnIndex(String columnName) {
        String upperColumnName;
        int index = -1;
        if (columnName != null && (upperColumnName = columnName.toUpperCase()).matches("[A-Z]*")) {
            for (int i = 0; i < upperColumnName.length(); ++i) {
                index += (upperColumnName.charAt(i) - 64) * (int)Math.pow(26.0, upperColumnName.length() - i - 1);
            }
        }
        return index;
    }

    protected String getColumnName(int columnIndex) {
        return JRStringUtil.getLetterNumeral(columnIndex + 1, true);
    }

    protected void resetAutoFilters() {
        this.autoFilterStart = null;
        this.autoFilterEnd = null;
    }

    protected boolean isUseTimeZone(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty(PROPERTY_USE_TIMEZONE)) {
            return this.getPropertiesUtil().getBooleanProperty(element, PROPERTY_USE_TIMEZONE, (boolean)((XlsReportConfiguration)this.getCurrentItemConfiguration()).isUseTimeZone());
        }
        return ((XlsReportConfiguration)this.getCurrentItemConfiguration()).isUseTimeZone();
    }

    protected Date translateDateValue(JRPrintText text, Date value) {
        if (this.isUseTimeZone(text)) {
            TimeZone tz = this.getTextTimeZone(text);
            value = JRDataUtils.translateToTimezone(value, tz);
        }
        return value;
    }

    protected boolean isValidScale(Integer scale) {
        return scale != null && scale > 9 && scale < 401;
    }

    protected Integer getMaxRowsPerSheet() {
        return ((XlsReportConfiguration)this.getCurrentItemConfiguration()).getMaxRowsPerSheet();
    }

    public boolean isWorkbookTemplateKeepSheets() {
        return this.keepTemplateSheets;
    }

    public void setWorkbookTemplateKeepSheets(boolean keepTemplateSheets) {
        this.keepTemplateSheets = keepTemplateSheets;
    }

    public String getWorkbookTemplate() {
        return this.workbookTemplate;
    }

    public void setWorkbookTemplate(String workbookTemplate) {
        this.workbookTemplate = workbookTemplate;
    }

    protected ExporterNature getNature() {
        return this.nature;
    }

    protected void exportEmptyReport() throws JRException, IOException {
        this.pageFormat = this.jasperPrint.getPageFormat();
        this.exportPage(new JRBasePrintPage(), null, 0, this.jasperPrint.getName());
    }

    public static String getColumIndexName(int colIndex, int maxColIndex) {
        if (colIndex < 0) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_NEGATIVE_COLUMN_INDEX, new Object[]{colIndex});
        }
        if (colIndex > maxColIndex) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_COLUMN_INDEX_BEYOND_LIMIT, new Object[]{colIndex, maxColIndex});
        }
        if (colIndex < 26) {
            return String.valueOf((char)(colIndex + 65));
        }
        if (colIndex < 702) {
            return String.valueOf((char)(colIndex / 26 + 64)) + String.valueOf((char)(colIndex % 26 + 65));
        }
        return String.valueOf((char)((colIndex - 26) / 676 + 64)) + String.valueOf((char)((colIndex - 26) % 676 / 26 + 65)) + String.valueOf((char)(colIndex % 26 + 65));
    }

    protected void configureDefinedNames(ExporterNature exporterNature, JRPrintElement element) {
        if (exporterNature instanceof JRXlsAbstractExporterNature) {
            this.configureDefinedNames(((JRXlsAbstractExporterNature)exporterNature).getDefinedNames(element));
        }
    }

    protected void configureDefinedNames(JRPropertiesUtil.PropertySuffix[] names) {
        if (names != null) {
            for (JRPropertiesUtil.PropertySuffix definedName : names) {
                this.configureDefinedNames(definedName);
            }
        }
    }

    protected void configureDefinedNames(JRPropertiesUtil.PropertySuffix propertySuffix) {
        if (propertySuffix != null) {
            String[] valueScope;
            String name = propertySuffix.getSuffix();
            String value = propertySuffix.getValue();
            if (name != null && name.trim().length() > 0 && value != null && value.length() > 0 && (valueScope = value.split(DEFAULT_DEFINED_NAME_SCOPE_SEPARATOR))[0] != null && valueScope[0].length() > 0) {
                String scope = valueScope.length > 1 ? valueScope[1] : DEFAULT_DEFINED_NAME_SCOPE;
                NameScope nameScope = new NameScope(name, scope);
                if (valueScope[0].startsWith("=")) {
                    this.definedNamesMap.put(nameScope, valueScope[0].substring(1));
                } else {
                    this.definedNamesMap.put(nameScope, valueScope[0]);
                }
            }
        }
    }

    protected abstract void openWorkbook(OutputStream var1) throws JRException, IOException;

    protected abstract void createSheet(CutsInfo var1, SheetInfo var2);

    protected abstract void closeSheet();

    protected abstract void closeWorkbook(OutputStream var1) throws JRException, IOException;

    protected abstract void setColumnWidth(int var1, int var2, boolean var3);

    protected abstract void setRowHeight(int var1, int var2, Cut var3, XlsRowLevelInfo var4) throws JRException;

    protected abstract void addRowBreak(int var1);

    protected abstract void addBlankCell(JRExporterGridCell var1, int var2, int var3) throws JRException;

    protected abstract void addOccupiedCell(OccupiedGridCell var1, int var2, int var3) throws JRException;

    protected abstract void exportText(JRPrintText var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportImage(JRPrintImage var1, JRExporterGridCell var2, int var3, int var4, int var5, int var6, JRGridLayout var7) throws JRException;

    protected abstract void exportRectangle(JRPrintGraphicElement var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportLine(JRPrintLine var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportFrame(JRPrintFrame var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportGenericElement(JRGenericPrintElement var1, JRExporterGridCell var2, int var3, int var4, int var5, int var6, JRGridLayout var7) throws JRException;

    protected abstract void setFreezePane(int var1, int var2);

    protected abstract void setFreezePane(int var1, int var2, boolean var3, boolean var4);

    protected abstract void setSheetName(String var1);

    protected abstract void setAutoFilter(String var1);

    protected abstract void setRowLevels(XlsRowLevelInfo var1, String var2);

    public class NameScope {
        private String name;
        private String scope;

        public NameScope(String name, String scope) {
            this.name = name;
            this.scope = scope;
        }

        public String getName() {
            return this.name;
        }

        public String getScope() {
            return this.scope;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return this == null;
            }
            if (this == null || !obj.getClass().equals(NameScope.class)) {
                return false;
            }
            NameScope obj1 = (NameScope)obj;
            return ObjectUtils.equals(this.name, obj1.name) && ObjectUtils.equals(this.scope, obj1.scope);
        }

        public int hashCode() {
            ObjectUtils.HashCode hash = ObjectUtils.hash();
            hash.add(this.name);
            hash.add(this.scope);
            return hash.getHashCode();
        }
    }

    public static class SheetInfo {
        public Integer sheetFirstPageIndex;
        public String sheetName;
        public Integer sheetFirstPageNumber;
        public Integer sheetPageScale;
        public Boolean sheetShowGridlines;
        public Color tabColor;
        public Boolean ignoreCellBorder;
        public Boolean ignoreCellBackground;
        public Boolean whitePageBackground;
        public Integer columnFreezeIndex;
        public Integer rowFreezeIndex;
        public Float columnWidthRatio;
        public SheetPrintSettings printSettings;

        public class SheetPrintSettings
        implements PrintPageFormat {
            private Integer pageHeight;
            private Integer pageWidth;
            private Integer topMargin;
            private Integer leftMargin;
            private Integer bottomMargin;
            private Integer rightMargin;
            private Integer headerMargin;
            private Integer footerMargin;
            private String headerLeft;
            private String headerCenter;
            private String headerRight;
            private String footerLeft;
            private String footerCenter;
            private String footerRight;
            private OrientationEnum orientation;

            @Override
            public Integer getPageHeight() {
                return this.pageHeight;
            }

            public void setPageHeight(Integer pageHeight) {
                this.pageHeight = pageHeight;
            }

            @Override
            public Integer getPageWidth() {
                return this.pageWidth;
            }

            public void setPageWidth(Integer pageWidth) {
                this.pageWidth = pageWidth;
            }

            @Override
            public Integer getTopMargin() {
                return this.topMargin;
            }

            public void setTopMargin(Integer topMargin) {
                this.topMargin = topMargin;
            }

            @Override
            public Integer getLeftMargin() {
                return this.leftMargin;
            }

            public void setLeftMargin(Integer leftMargin) {
                this.leftMargin = leftMargin;
            }

            @Override
            public Integer getBottomMargin() {
                return this.bottomMargin;
            }

            public void setBottomMargin(Integer bottomMargin) {
                this.bottomMargin = bottomMargin;
            }

            @Override
            public Integer getRightMargin() {
                return this.rightMargin;
            }

            public void setRightMargin(Integer rightMargin) {
                this.rightMargin = rightMargin;
            }

            public Integer getHeaderMargin() {
                return this.headerMargin;
            }

            public void setHeaderMargin(Integer headerMargin) {
                this.headerMargin = headerMargin;
            }

            public Integer getFooterMargin() {
                return this.footerMargin;
            }

            public void setFooterMargin(Integer footerMargin) {
                this.footerMargin = footerMargin;
            }

            public String getHeaderLeft() {
                return this.headerLeft;
            }

            public void setHeaderLeft(String headerLeft) {
                this.headerLeft = headerLeft;
            }

            public String getHeaderCenter() {
                return this.headerCenter;
            }

            public void setHeaderCenter(String headerCenter) {
                this.headerCenter = headerCenter;
            }

            public String getHeaderRight() {
                return this.headerRight;
            }

            public void setHeaderRight(String headerRight) {
                this.headerRight = headerRight;
            }

            public String getFooterLeft() {
                return this.footerLeft;
            }

            public void setFooterLeft(String footerLeft) {
                this.footerLeft = footerLeft;
            }

            public String getFooterCenter() {
                return this.footerCenter;
            }

            public void setFooterCenter(String footerCenter) {
                this.footerCenter = footerCenter;
            }

            public String getFooterRight() {
                return this.footerRight;
            }

            public void setFooterRight(String footerRight) {
                this.footerRight = footerRight;
            }

            @Override
            public OrientationEnum getOrientation() {
                return this.orientation;
            }

            public void setOrientation(OrientationEnum orientation) {
                this.orientation = orientation;
            }
        }
    }

    protected static class TextAlignHolder {
        public final HorizontalTextAlignEnum horizontalAlignment;
        public final VerticalTextAlignEnum verticalAlignment;
        public final RotationEnum rotation;

        public TextAlignHolder(HorizontalTextAlignEnum horizontalAlignment, VerticalTextAlignEnum verticalAlignment, RotationEnum rotation) {
            this.horizontalAlignment = horizontalAlignment;
            this.verticalAlignment = verticalAlignment;
            this.rotation = rotation;
        }
    }
}

