/*
 * Decompiled with CFR 0.152.
 */
package de.cenote.jasperstarter.gui;

import de.cenote.jasperstarter.gui.ParameterPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import net.sf.jasperreports.engine.JRParameter;

public class ParameterPrompt {
    Component parent;
    JRParameter[] jrParameters;
    Map params;
    JScrollPane scrollPane;
    String reportName;
    AtomicBoolean valid = new AtomicBoolean();

    public ParameterPrompt(Component parent, JRParameter[] jrParameters, Map<String, Object> params, String reportName, boolean isForPromptingOnly, boolean isUserDefinedOnly, boolean emptyOnly) {
        this.valid.set(true);
        this.parent = parent;
        this.jrParameters = jrParameters;
        this.params = params;
        this.reportName = reportName;
        final JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.setLayout(new BoxLayout(panel, 1));
        this.scrollPane = new JScrollPane(panel);
        this.scrollPane.setPreferredSize(new Dimension(600, 250));
        for (JRParameter param : jrParameters) {
            if (param.isSystemDefined() && isUserDefinedOnly || !param.isForPrompting() && isForPromptingOnly || params.get(param.getName()) != null && emptyOnly) continue;
            panel.add(new ParameterPanel(param, params, this.valid));
        }
        panel.add(new JSeparator());
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!(evt.getNewValue() instanceof JComponent)) {
                    return;
                }
                JComponent focused = (JComponent)evt.getNewValue();
                if (panel.isAncestorOf(focused)) {
                    JComponent myComponent = (JComponent)focused.getParent().getParent();
                    myComponent.scrollRectToVisible(new Rectangle(0, 0, 0, 80));
                }
            }
        });
    }

    public int show() {
        JDialog dialog;
        final JOptionPane optionPane = new JOptionPane(this.scrollPane, -1, 2);
        JFrame frame = new JFrame();
        if (this.parent == null) {
            frame.setTitle("JasperStarter - Parameter Prompt: " + this.reportName);
            frame.setUndecorated(true);
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
            dialog = new JDialog(frame);
        } else {
            dialog = this.parent instanceof Window ? new JDialog((Window)this.parent) : (this.parent instanceof Frame ? new JDialog((Frame)this.parent) : (this.parent instanceof Dialog ? new JDialog((Dialog)this.parent) : new JDialog()));
        }
        dialog.setTitle("JasperStarter - Parameter Prompt: " + this.reportName);
        dialog.setContentPane(optionPane);
        dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        dialog.setDefaultCloseOperation(0);
        dialog.setSize(636, 344);
        dialog.setLocationRelativeTo(this.parent);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                optionPane.setValue(new Integer(2));
            }
        });
        optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (dialog.isVisible() && e.getSource() == optionPane && prop.equals("value")) {
                    if (ParameterPrompt.this.valid.get() || (Integer)optionPane.getValue() == 2) {
                        dialog.setVisible(false);
                    } else {
                        optionPane.setValue(new Integer(1));
                    }
                }
            }
        });
        dialog.pack();
        dialog.setVisible(true);
        int retval = (Integer)optionPane.getValue();
        dialog.dispose();
        frame.dispose();
        return retval;
    }
}

