<?php 

namespace App\Http\Resources\Transaction;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\BaseJsonResource;

class EntryTypeResource extends BaseJsonResource
{
    public function toArray($request)
    {

        $array = [
            'id' => $this->id,
            'name' => $this->name,
            'label' => $this->label,
            'description' => $this->description,
            'base_type' => $this->base_type,
            'numbering' => $this->numbering,
            'prefix' => $this->prefix,
            'suffix' => $this->suffix,
            'zero_padding' => $this->zero_padding,
            'restriction_bankcash' => $this->restriction_bankcash,
            'tag' => new EntryTagResource($this->tag)
        ];

        $array = $this->base($array);
        
        return $array;
    }
}