<?php

use Illuminate\Database\Seeder;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class UnitTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /*
         * Permission Types
         *
         */
        $Permissionitems = [
            [
                'name'        => 'Pieces',
                'alias'        => 'pcs',
                'type' => 'QTY',
            ],
            [
                'name'        => 'Kilogram',
                'alias'        => 'kg',
                'type' => 'WEIGHT',
            ],
            [
                'name'        => 'Gram',
                'alias'        => 'gm',
                'type' => 'WEIGHT',
            ],
            [
                'name'        => 'Litre',
                'alias'        => 'ltr',
                'type' => 'WEIGHT',
            ],
            [
                'name'        => 'mm',
                'alias'        => 'mm',
                'type' => 'DIMENSION',
            ],
            [
                'name'        => 'feet',
                'alias'        => 'ft',
                'type' => 'DIMENSION',
            ],
            [
                'name'        => 'Centimeter',
                'alias'        => 'cm',
                'type' => 'DIMENSION',
            ],
            [
                'name'        => 'Inch',
                'alias'        => 'inch',
                'type' => 'DIMENSION',
            ],
        ];

        /*
         * Add Permission Items
         *
         */
        foreach ($Permissionitems as $Permissionitem) {
            //if ($newPermissionitem === null) {
                DB::table('units')->insert([
                    'name' => $Permissionitem['name'],
                    'alias'=> $Permissionitem['alias'],
                    'type'=> $Permissionitem['type'],
                    'created_at' =>Carbon::now()
                ]);
            //}
        }
    }
}
