<?php 

namespace App\Http\Resources\Dasboard;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Models\User;
use App\Http\Resources\BaseJsonResource;

class DashboardItemResource extends BaseJsonResource
{
    public function toArray($request)
    {

        $array = [
            'type' => isset($this->type)?$this->type:null,
            'heading' => isset($this->heading)?$this->heading:null,
            'subheading' => isset($this->subheading)?$this->subheading:null,
            'footer' => isset($this->footer)?$this->footer:null,
            'items' => ItemResource::collection($this->items)
        ];
        
        return $array;
    }
}