<?php 

namespace App\Http\Resources\Transaction;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\BaseJsonResource;

class EntryResource extends BaseJsonResource
{
    public function toArray($request)
    {

        $array = [
            'id' => $this->id,
            'entry_type' => new EntryTypeResource($this->entryType),
            'ref_number' => $this->ref_number,
            'tr_date' => $this->tr_date,
            'cr_total' => $this->cr_total,
            'dr_total' => $this->dr_total,
            'narration' => $this->narration,
            'invoice_ref_id' => $this->invoice_ref_id,
            'invoice_data' => ((!empty($this->invoice))? new \App\Http\Resources\Invoice\InvoiceResource($this->invoice) :null),
            'entry_items' => EntryItemResource::collection($this->items)
        ];

        $array = $this->base($array);
        
        return $array;
    }
}