<?php

namespace App\Http\Controllers\AdminApi;
use Illuminate\Support\Facades\DB;
use Log;
use App\Http\Controllers\AppBaseController;
use Response;


class AdminApiController extends AppBaseController
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function getAllUserRole($type, $query = null){
        //DB::connection()->enableQueryLog();
        Log::info('getAllUserRole '.$type.' query '.$query); 
        if($type == 'consumable_categories'){
            $json = DB::table('consumable_categories')->select('id',"name->en  as name")->where('name->en','LIKE','%'.$query.'%')->get();
             //$json = DB::table('user_roles')->select('id','role_name')->where()->get();
             Log::info('getAllUserRole data '.$json); 
             return  response()->json(($json));
         }else if($type == 'consumable_items'){
             $cat = \App\Models\ConsumableCategory::where('name->en','=', $query)->first();
            $json = DB::table('consumable_items')->
            select(DB::raw("consumable_items.id as id, consumable_items.name->>'$.en' as name , consumable_categories.name->>'$.en' as category, units.alias as unit"))->
            join('consumable_categories', 'consumable_items.category_id', '=', 'consumable_categories.id')->
            join('units', 'consumable_items.opening_stock_unit', '=', 'units.id')->
            where('category_id','=',$cat->id)->get();
             //$json = DB::table('user_roles')->select('id','role_name')->where()->get();
             Log::info('consumable_items data '.$json); 
             return  response()->json(($json));
         } else if($type =='consumable_settings'){
            $json = DB::table('consumable_settings')->select('id',"name")->where('name','LIKE','%'.$query.'%')->get();
            return  response()->json(($json));
         } else if($type =='patti'){
            $json = DB::table('consumable_settings')->select('id',"name")->where([['name','LIKE','%'.$query.'%'],['type','=','PATTI']])->get();
            return  response()->json(($json));
         } else if($type =='bond_process'){
            $json = DB::table('bond_process_params')->select('id',"name as name")->where('name','LIKE','%'.$query.'%')->get();
            return  response()->json(($json));
         } else if($type =='bond_designs'){
            $json = DB::table('bond_designs')->select('id',"name")->where('name','LIKE','%'.$query.'%')->get();
            return  response()->json(($json));
         } else if($type =='bonds'){
            $json = DB::table('bonds')->select('id',"name")->where('name','LIKE','%'.$query.'%')->get();
            return  response()->json(($json));
         } else if($type =='packing_settings'){
            $json = DB::table('consumable_settings')->select('id',"name")->where([['name','LIKE','%'.$query.'%'],['type','=','PACKING']])->get();
            return  response()->json(($json));
         } else if($type =='finishing_settings'){
            $json = DB::table('consumable_settings')->select('id',"name")->where([['name','LIKE','%'.$query.'%'],['type','=','FINISHING']])->get();
            return  response()->json(($json));
         } else if($type =='unit_qty'){
            $json = DB::table('units')->select('id',"name", "alias")->where([['name','LIKE','%'.$query.'%'],['type','=','QTY']])->get();
            return  response()->json(($json));
         } else if($type =='prod_status'){
            $json = DB::table('production_status')->select('id',"name")->where([['name','LIKE','%'.$query.'%']])->get();
            return  response()->json(($json));
         } else if($type =='bond_product'){
            $json = DB::table('bond_products')->select(DB::raw("bond_products.id as `id`, bond_products.name as `name` , bond_designs.name as `design_name`, units.alias as `unit`"))->
            join('bond_designs', 'bond_products.bond_design_id', '=', 'bond_designs.id')->
            join('units', 'bond_products.qty_unit_id', '=', 'units.id')->
            where([['bond_products.name','LIKE','%'.$query.'%']])->get();
            return  response()->json(($json));
         }else if($type =='bond_product_type'){
            $json = DB::table('bond_product_types')->select('id','name')->where([['name','LIKE','%'.$query.'%']])->get();
            return  response()->json(($json));
         }else if($type == 'account_group'){
            $json = DB::table('account_groups')->select('id','name',"parent_id")->where([['name','LIKE','%'.$query.'%']])->get();
            //$categories = (new \App\Models\AccountGroup())->getChildNameArray();
            return  response()->json(($json));
         }else if($type == 'group_list'){
            $categories = (new \App\Models\AccountGroup())->getChildNameArray();
            return  response()->json(($categories));
         }else if($type == 'entry_types'){
            $categories = \App\Models\EntryType::all();
            return  \App\Http\Resources\Transaction\EntryTypeResource::collection($categories);
         }else if($type == 'employee'){
            $json = DB::table('employees')->select('id',"name")->where([['name','LIKE','%'.$query.'%']])->get();
            return  response()->json(($json));
         }else if($type == 'state'){
            $json = DB::table('state_list')->select('id',"name")->where([['name','LIKE','%'.$query.'%']])->get();
            return  response()->json(($json));
         } else if($type == 'accounts'){
            $json =null;
            if(empty($query)){
                $json = DB::table('accounts')->select('id','name', 'balance_cr','balance_dr')->orderBy('created_at','DESC')->get();
             }else{
                $accountGroup = \App\Models\AccountGroup::where('name','=',$query)->first();
                $idArray= $accountGroup->allChilds()->pluck('id')->toArray();
                array_push($idArray,$accountGroup->id);

                $json = DB::table('accounts')->select('id','name', 'group_id','balance_cr','balance_dr')->whereIn('group_id', $idArray)->orderBy('created_at','DESC')->get();
             }
            return  response()->json(($json));
         }  

         response()->json(['success' => false, 'msg' =>'']);     
     }

     public function freshData($type, $query = null){
        if($type == 'accounts'){
            $json =null;
            if(empty($query)){
                $json = DB::table('accounts')->select('id','name', 'balance_cr','balance_dr')->orderBy('created_at','DESC')->get();
             }else{
                $accountGroup = \App\Models\AccountGroup::where('name','=',$query)->first();
                $idArray= $accountGroup->allChilds()->pluck('id')->toArray();
                array_push($idArray,$accountGroup->id);

                $json = DB::table('accounts')->select('id','name', 'group_id','balance_cr','balance_dr')->whereIn('group_id', $idArray)->orderBy('created_at','DESC')->get();
             }
            return  response()->json(($json));
         }    
     }
     
     public function streamProtectedMedia($folder, $fileName, $ext){
        
        //return 
     }

}