<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBondMaterialRecipesTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bond_material_recipes', function (Blueprint $table) {
            //$table->bigIncrements('id');
            $table->unsignedBigInteger('material_id')->nullable(false)->unique();
            $table->unsignedBigInteger('bond_product_id');
            $table->unsignedBigInteger('bond_process_id')->nullable(false);
            $table->primary('material_id');
            $table->decimal('weight', 25, 2)->default(0);
            $table->decimal('powder_cost', 25, 2)->default(0);


            $table->unsignedBigInteger('packing_settings_id')->nullable(false);
            $table->unsignedBigInteger('finishing_settings_id')->nullable(false);
            $table->decimal('total_piece_packing', 25, 2)->nullable(true)->default(0);


            //$table->unsignedBigInteger('weight_unit_id')->nullable();
            //$table->unsignedBigInteger('expected_qty_unit_id')->nullable();
            
            //$table->decimal('expected_manufacturing_time', 10, 2)->nullable();
            $priority = CreateUsersTable::f(config('app_data.priority_enum'));

            
            $table->enum('priority', $priority)->default('NORMAL');    
            

            //$table->mediumText('add_data');            
            $table->timestamps();
            //$table->softDeletes();

            $table->unsignedBigInteger('created_by')->nullable(false);
            $table->unsignedBigInteger('updated_by')->nullable();
            //$table->unsignedBigInteger('deleted_by')->nullable();

           // $table->unsignedBigInteger('bond_process_params_id')->nullable(false);
            
            // $table->foreign('expected_qty_unit_id')->references('id')->on('units');            
            // $table->foreign('weight_unit_id')->references('id')->on('units');            

           // $table->foreign('bond_product_id')->references('id')->on('bonds');   
            $table->foreign('bond_process_id')->references('id')->on('bond_process_params');   
             

            //$table->foreign('bond_process_params_id')->references('id')->on('bond_process_params');  
               
            $table->foreign('created_by')->references('id')->on('users');
            $table->foreign('updated_by')->references('id')->on('users');        
            //$table->foreign('deleted_by')->references('id')->on('users');        
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('bond_material_recipes');
    }
}
