-- MySQL dump 10.13  Distrib 5.7.29, for Linux (x86_64)
--
-- Host: localhost    Database: amartoolsdb
-- ------------------------------------------------------
-- Server version	5.7.29-0ubuntu0.18.04.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `account_groups`
--

DROP TABLE IF EXISTS `account_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint(20) unsigned DEFAULT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `affects_gross` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `account_groups_name_unique` (`name`),
  UNIQUE KEY `account_groups_code_unique` (`code`),
  KEY `account_groups_created_by_foreign` (`created_by`),
  KEY `account_groups_updated_by_foreign` (`updated_by`),
  CONSTRAINT `account_groups_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `account_groups_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `account_groups`
--

LOCK TABLES `account_groups` WRITE;
/*!40000 ALTER TABLE `account_groups` DISABLE KEYS */;
INSERT INTO `account_groups` VALUES (1,NULL,1,NULL,'Assets',NULL,0,'2020-02-14 17:52:54',NULL),(2,NULL,1,NULL,'Liabilities and Owners Equity',NULL,0,'2020-02-14 17:52:54',NULL),(3,NULL,1,NULL,'Incomes',NULL,0,'2020-02-14 17:52:54',NULL),(4,NULL,1,NULL,'Expenses',NULL,0,'2020-02-14 17:52:54',NULL),(5,1,1,NULL,'Fixed Assets',NULL,0,'2020-02-14 17:52:54',NULL),(6,1,1,NULL,'Current Assets',NULL,0,'2020-02-14 17:52:54',NULL),(7,1,1,NULL,'Investments',NULL,0,'2020-02-14 17:52:54',NULL),(8,2,1,NULL,'Capital Account',NULL,0,'2020-02-14 17:52:54',NULL),(9,2,1,NULL,'Current Liabilities',NULL,0,'2020-02-14 17:52:54',NULL),(10,2,1,NULL,'Loans (Liabilities)',NULL,0,'2020-02-14 17:52:54',NULL),(11,3,1,NULL,'Direct Incomes',NULL,1,'2020-02-14 17:52:54',NULL),(12,4,1,NULL,'Direct Expenses',NULL,1,'2020-02-14 17:52:54',NULL),(13,3,1,NULL,'Indirect Incomes',NULL,0,'2020-02-14 17:52:54',NULL),(14,4,1,NULL,'Indirect Expenses',NULL,0,'2020-02-14 17:52:54',NULL),(15,3,1,NULL,'Sales',NULL,0,'2020-02-14 17:52:54',NULL),(16,4,1,NULL,'Purchases',NULL,0,'2020-02-14 17:52:54',NULL),(17,12,1,NULL,'Salary & Wages',NULL,1,'2020-02-14 17:52:54',NULL),(18,16,1,NULL,'Die',NULL,0,'2020-02-14 17:52:54',NULL),(19,16,1,NULL,'Punch',NULL,0,'2020-02-14 17:52:54',NULL),(20,16,1,NULL,'Patti',NULL,0,'2020-02-14 17:52:54',NULL),(21,16,1,NULL,'Binder & Chemical',NULL,0,'2020-02-14 17:52:54',NULL),(22,16,1,NULL,'Metal Powder',NULL,0,'2020-02-14 17:52:54',NULL),(23,16,1,NULL,'Diamond Powder',NULL,0,'2020-02-14 17:52:54',NULL),(24,16,1,NULL,'Machine Accessories',NULL,0,'2020-02-14 17:52:54',NULL);
/*!40000 ALTER TABLE `account_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Temporary table structure for view `account_total_view`
--

DROP TABLE IF EXISTS `account_total_view`;
/*!50001 DROP VIEW IF EXISTS `account_total_view`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `account_total_view` AS SELECT 
 1 AS `account_id`,
 1 AS `group_id`,
 1 AS `name`,
 1 AS `account_group`,
 1 AS `tr_date`,
 1 AS `month`,
 1 AS `cr_total`,
 1 AS `dr_total`*/;
SET character_set_client = @saved_cs_client;

--
-- Temporary table structure for view `account_view`
--

DROP TABLE IF EXISTS `account_view`;
/*!50001 DROP VIEW IF EXISTS `account_view`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `account_view` AS SELECT 
 1 AS `name`,
 1 AS `account_id`,
 1 AS `account_group`,
 1 AS `group_id`,
 1 AS `tr_date`,
 1 AS `month`,
 1 AS `entrytype`,
 1 AS `invoice_ref_id`,
 1 AS `cr_total`,
 1 AS `dr_total`,
 1 AS `narration`,
 1 AS `entry_id`,
 1 AS `yearmonthindex`,
 1 AS `op_balance_cr`,
 1 AS `op_balance_dr`*/;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `balance_cr` decimal(25,2) NOT NULL DEFAULT '0.00',
  `balance_dr` decimal(25,2) NOT NULL DEFAULT '0.00',
  `type` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `reconciliation` tinyint(1) NOT NULL DEFAULT '0',
  `phoneNo` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gstNo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `billing_address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `contact_person` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `accounts_name_unique` (`name`),
  KEY `accounts_group_id_foreign` (`group_id`),
  KEY `accounts_created_by_foreign` (`created_by`),
  KEY `accounts_updated_by_foreign` (`updated_by`),
  KEY `accounts_state_id_foreign` (`state_id`),
  CONSTRAINT `accounts_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `accounts_group_id_foreign` FOREIGN KEY (`group_id`) REFERENCES `account_groups` (`id`),
  CONSTRAINT `accounts_state_id_foreign` FOREIGN KEY (`state_id`) REFERENCES `state_list` (`id`),
  CONSTRAINT `accounts_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=69 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (9,15,'Salasar Granite Ind',0.00,0.00,'0',1,NULL,'S.PAREEK0874@GMAIL.COM','08ACHFS6434M1ZK',NULL,NULL,3,NULL,'2020-02-22 05:38:07','2020-02-22 05:38:07',NULL,'',8),(10,15,'Prerna Landcon pvt.ltd',0.00,0.00,'1',0,NULL,NULL,'08AADCP9656R1ZD','RiICO IND AREA RAJSAMAND',NULL,3,NULL,'2020-02-23 00:28:51','2020-02-23 00:28:51',NULL,'',8),(11,15,'Rajputana granite pvt.ltd',0.00,0.00,'1',0,NULL,NULL,'08AABCR0447G1ZL','TASOL ROAD PASSUND RAJSAMAND',NULL,3,NULL,'2020-02-23 00:31:40','2020-02-23 00:31:40',NULL,'',8),(12,15,'Balaji Stone Mart Pvt.Ltd',0.00,0.00,'1',0,NULL,NULL,'08AAFCB1596C1ZT','RIICO AREA DHOINDA RAJSAMAND',NULL,3,NULL,'2020-02-23 00:33:39','2020-02-23 00:33:39',NULL,'',8),(13,15,'Shree Shyam Granite',0.00,0.00,'1',0,NULL,NULL,'08ACIF5679M1Z6','MERDA ROAD  RAJSAMAND',NULL,3,NULL,'2020-02-23 00:35:30','2020-02-23 00:35:30',NULL,'',8),(14,15,'Asocited Marmo & Granite Pvt Ltd',0.00,0.00,'1',0,NULL,NULL,'08AACCA728561ZY','PASSOND  RAJSAMAND',NULL,3,NULL,'2020-02-23 00:38:02','2020-02-23 00:38:02',NULL,'',8),(15,15,'Satynarayan Marble Pvt.Ltd',0.00,0.00,'1',0,NULL,NULL,'08AAFCS5548D1ZA','PASSOND  RAJSAMAND',NULL,3,NULL,'2020-02-23 00:39:38','2020-02-23 00:39:38',NULL,'',8),(16,15,'Z And D Diamands',0.00,0.00,'1',0,NULL,NULL,'08DHHPM3553B1ZH','KANKROLI RAJSAMAND',NULL,3,NULL,'2020-02-23 00:41:40','2020-02-23 00:41:40',NULL,'',8),(17,15,'Shiv Shakti Marble Supplier',0.00,0.00,'1',0,NULL,NULL,'08ADTPG8892Q1Z7','RAJNAGER RAJSAMAND',NULL,3,NULL,'2020-02-23 00:43:52','2020-02-23 00:43:52',NULL,'',8),(18,15,'Raj Rajeshwari Marble',0.00,0.00,'1',0,NULL,NULL,'08AAYPB9818R1ZJ','TASOL ROAD PASSOND RAJSAMAND',NULL,3,NULL,'2020-02-23 00:45:32','2020-02-23 00:45:32',NULL,'',8),(19,15,'Thakur Marble Pvt Ltd',0.00,0.00,'1',0,NULL,NULL,'08AABCT5205A1ZX','TASOL ROAD PASSOND RAJSAMAND',NULL,3,NULL,'2020-02-23 00:46:49','2020-02-23 00:46:49',NULL,'',8),(20,15,'Shree Khandal Mata ji Pvt Ltd',0.00,0.00,'0',0,NULL,NULL,'08AAIC56701M1ZZ','PASSOND RAJSAMAND',NULL,3,3,'2020-02-23 00:48:15','2020-02-23 18:05:33',NULL,'',8),(21,15,'Shri Bala Ji White Marmo Stones Pvt Ltd',0.00,0.00,'1',0,NULL,NULL,'08AAHCS6029H1Z6','PASSOND RAJSAMAND',NULL,3,NULL,'2020-02-23 00:50:07','2020-02-23 00:50:07',NULL,'',8),(22,15,'Shiv Bhole Dia Tools',0.00,0.00,'1',0,NULL,NULL,'08AURPM4999H1ZN','KANKROLI RAJSAMAND',NULL,3,NULL,'2020-02-23 00:52:01','2020-02-23 00:52:01',NULL,'',8),(23,15,'Synergy India Diamond',0.00,0.00,'1',0,NULL,NULL,'08ACIF9632E1ZU','DIDWANA NAGAUR TOOLS',NULL,3,NULL,'2020-02-23 00:54:52','2020-02-23 00:54:52',NULL,'',8),(24,15,'Saraswati Marble & Granite Ind pvt Ltd',0.00,0.00,'1',0,NULL,NULL,'08AAACS1104Q1ZC','PASSOND RAJSAMAND',NULL,3,NULL,'2020-02-23 00:57:06','2020-02-23 00:57:06',NULL,'',8),(25,15,'Mahesh Granite',0.00,0.00,'1',0,NULL,NULL,'08AAXFM4323K1ZQ','RIICO AREYA DHOINDA RAJSAMAND',NULL,3,3,'2020-02-23 00:58:08','2020-02-23 17:35:46',NULL,'',8),(26,19,'A N Creations',0.00,0.00,'0',0,NULL,NULL,'08ABMFA8592N1ZI','SODALA JAIPUR',NULL,3,3,'2020-02-23 01:06:52','2020-02-23 18:10:55',NULL,'',NULL),(27,22,'Mittal Industries',0.00,0.00,'1',0,NULL,NULL,'08AFNPM7491R1Z8','SITAPURA  JAIPUR',NULL,3,NULL,'2020-02-23 01:10:50','2020-02-23 01:10:50',NULL,'',NULL),(28,22,'Crown Ferro Alloys Pvt Ltd',0.00,0.00,'1',0,NULL,NULL,'24AAACC7672B1Z0','MAKARPURA VADODARA',NULL,3,NULL,'2020-02-23 01:20:02','2020-02-23 01:20:02',NULL,'',NULL),(29,22,'Sarda Industrial Enterprised',0.00,0.00,'1',0,NULL,NULL,'24AATAS3741A1ZF','JAIPUR',NULL,3,NULL,'2020-02-23 01:21:46','2020-02-23 01:21:46',NULL,'',NULL),(30,23,'Dhvani Marketing Services',0.00,0.00,'0',0,NULL,NULL,'27AACFD5282H1ZF','MUMBAI',NULL,3,1,'2020-02-23 01:24:18','2020-02-26 05:24:44',NULL,'',NULL),(31,23,'SHANTI UDYOG',0.00,0.00,'0',0,NULL,NULL,'08AADPG9287E1ZJ','JAIPUR',NULL,3,NULL,'2020-02-23 01:25:55','2020-02-23 01:25:55',NULL,'',NULL),(32,23,'VIVEK AGENCIES',0.00,0.00,'0',0,NULL,NULL,'27AACFV3899E1ZS','MUMBAI',NULL,3,NULL,'2020-02-23 01:28:10','2020-02-23 01:28:10',NULL,'',NULL),(33,15,'KAMAL JI',2700.00,0.00,'0',0,NULL,NULL,NULL,'RAJSAMAND',NULL,3,NULL,'2020-02-23 01:30:58','2020-02-23 01:30:58',NULL,'',8),(34,15,'JAGDISH JI FACTORY',49600.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-02-23 01:37:36','2020-02-23 01:37:36',NULL,'',8),(35,15,'SIHODI MARBLE',0.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-02-23 01:38:34','2020-02-23 01:38:34',NULL,'',8),(36,15,'SHREE LAHARI LAL JI MORCHANA',0.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-02-23 01:39:24','2020-02-23 01:39:24',NULL,'',8),(37,15,'ANAND TRADING COMPANY',0.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-02-23 01:39:45','2020-02-23 01:39:45',NULL,'',8),(38,15,'kishan luhar amit road',0.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-02-23 01:40:43','2020-02-23 01:40:43',NULL,'',8),(39,15,'ASHOK JI BOHARA MORCHANA',0.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,1,1,'2020-02-23 01:42:03','2020-02-23 01:51:46',NULL,'',8),(40,15,'SHREE MAHASH JI SHRIMALI',76800.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-02-23 01:44:34','2020-02-23 01:44:34',NULL,'',8),(41,15,'LAXMAN JI DALPAT JI',0.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-02-23 01:46:35','2020-02-23 01:46:35',NULL,'',8),(42,15,'SHREE MALIKA ARJUN MARBLE',17464.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-02-23 01:47:32','2020-02-23 01:47:32',NULL,'',8),(43,15,'SHREE KANIYA LAL JI',1100.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-02-23 01:48:30','2020-02-23 01:48:30',NULL,'',8),(44,15,'SHREE SAMDHANI MARBLE',0.00,0.00,'0',0,NULL,NULL,NULL,'AMET ROAD',NULL,3,NULL,'2020-02-23 01:49:44','2020-02-23 01:49:44',NULL,'',8),(45,15,'MANTRI MARBLE PVT LTD',0.00,0.00,'0',0,NULL,NULL,NULL,'TASOOL  ROAD',NULL,3,NULL,'2020-02-23 01:50:32','2020-02-23 01:50:32',NULL,'',8),(46,15,'S R MARBLE AAGRIYA',0.00,0.00,'0',0,NULL,NULL,NULL,'AGRIYA',NULL,3,NULL,'2020-02-23 01:51:30','2020-02-23 01:51:30',NULL,'',8),(47,15,'PROGRESHIVE GRANITE MOHI',6500.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-02-23 17:36:42','2020-02-23 17:36:42',NULL,'',8),(48,15,'MHARAJ SHANTINATH',23400.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-02-23 18:02:04','2020-02-23 18:02:04',NULL,'',8),(49,15,'BHAWAR JI AMIT ROAD',5400.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-02-23 18:06:41','2020-02-23 18:06:41',NULL,'',8),(50,15,'ALANKAR MARBLE',48000.00,0.00,'0',0,NULL,NULL,NULL,'MHOKHAMPURA',NULL,3,NULL,'2020-02-23 18:08:15','2020-02-23 18:08:15',NULL,'',8),(51,15,'papu ji brazing riico',2700.00,0.00,'0',0,NULL,NULL,NULL,'RIICO BRAZING CENTER',NULL,3,NULL,'2020-02-23 18:09:24','2020-02-23 18:09:24',NULL,'',8),(52,15,'KAMAL MARBLE',46200.00,0.00,'0',0,NULL,NULL,NULL,'PASSUND RAJSAMAND',NULL,3,NULL,'2020-02-23 18:12:09','2020-02-23 18:12:09',NULL,'',8),(53,15,'SHREE CHARBHUJA GRANITE',0.00,41500.00,'0',0,NULL,NULL,NULL,'KELWA JETPURA',NULL,3,3,'2020-02-23 18:13:51','2020-03-06 17:57:05',NULL,'',8),(54,15,'B N MARBLE',14160.00,0.00,'0',0,NULL,NULL,NULL,'MOKHAMPURA',NULL,3,NULL,'2020-02-23 18:15:26','2020-02-23 18:15:26',NULL,'',8),(55,15,'N M MARBLE',44000.00,0.00,'0',0,NULL,NULL,NULL,'UDAIPUR',NULL,3,NULL,'2020-02-23 18:16:42','2020-02-23 18:16:42',NULL,'',8),(56,15,'SHIVA MARBLE',39380.00,0.00,'0',0,NULL,NULL,NULL,'PASSUND',NULL,3,NULL,'2020-02-23 18:19:32','2020-02-23 18:19:32',NULL,'',8),(57,15,'NATURAL MARBLE',66000.00,0.00,'0',0,NULL,NULL,NULL,'AMET ROAD',NULL,3,NULL,'2020-02-23 18:23:28','2020-02-23 18:23:28',NULL,'',8),(58,15,'NATRAJ MARBLE',30000.00,0.00,'0',0,NULL,NULL,NULL,'AMET ROAD',NULL,3,NULL,'2020-02-23 18:24:34','2020-02-23 18:24:34',NULL,'',8),(59,15,'bhawani marble',30000.00,0.00,'0',0,NULL,NULL,NULL,'TASOOL ROAD',NULL,3,NULL,'2020-02-23 18:25:25','2020-02-23 18:25:25',NULL,'',8),(60,6,'Cash Account',0.00,0.00,'1',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-02-23 18:31:24','2020-02-23 18:31:24',NULL,'',NULL),(61,6,'Amar Axis Bank',0.00,0.00,'1',0,NULL,NULL,NULL,NULL,NULL,3,1,'2020-02-23 18:31:50','2020-03-01 12:45:44',NULL,'',NULL),(62,19,'NICKUNJ EXIMP',23600.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,1,'2020-02-27 10:57:53','2020-02-27 12:14:16',NULL,'',NULL),(63,15,'shree kesariya ji marble',0.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-03-01 07:43:20','2020-03-01 07:43:20',NULL,'',8),(64,15,'JAGDISH JI GURJAR',15000.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-03-03 11:40:46','2020-03-03 11:40:46',NULL,'',8),(65,15,'vikas ji',0.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-03-04 06:53:31','2020-03-04 06:53:31',NULL,'',8),(66,15,'test sales account',0.00,2000.00,'0',0,NULL,'pareekpradeep786@gmail.com','ADJDJJSJBKLL','A-11 GOVIND NAGAR HOUSING BOARD COLONY',NULL,1,1,'2020-03-05 02:10:01','2020-03-09 11:17:44',NULL,'',8),(67,19,'prem ji grefied',7210.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,3,'2020-03-05 07:47:04','2020-03-05 07:49:57',NULL,'',NULL),(68,24,'NAKODA TRACTOR',0.00,0.00,'0',0,NULL,NULL,'08ABUPB6976F1Z5',NULL,NULL,3,NULL,'2020-03-06 05:42:50','2020-03-06 05:42:50',NULL,'',NULL);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bond_designs`
--

DROP TABLE IF EXISTS `bond_designs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bond_designs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size_specification` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size_print` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `weight1_lower` decimal(25,2) DEFAULT NULL,
  `weight1_upper` decimal(25,2) DEFAULT NULL,
  `weight1_nos` int(11) DEFAULT NULL,
  `weight2_lower` decimal(25,2) DEFAULT NULL,
  `weight2_upper` decimal(25,2) DEFAULT NULL,
  `weight2_nos` int(11) DEFAULT NULL,
  `weight1_average` decimal(25,2) DEFAULT NULL,
  `weight2_average` decimal(25,2) DEFAULT NULL,
  `weight1_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `weight2_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `consumable_setting_1` bigint(20) unsigned NOT NULL,
  `consumable_setting_2` bigint(20) unsigned DEFAULT NULL,
  `piece_net_weight` decimal(25,2) NOT NULL,
  `shape` enum('BOX-SHAPE','M-SHAPE','B-SHAPE','V-SHAPE') COLLATE utf8mb4_unicode_ci NOT NULL,
  `taper` decimal(25,2) NOT NULL DEFAULT '0.00',
  `width` decimal(25,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bond_designs_created_by_foreign` (`created_by`),
  KEY `bond_designs_updated_by_foreign` (`updated_by`),
  KEY `bond_designs_consumable_setting_1_foreign` (`consumable_setting_1`),
  KEY `bond_designs_consumable_setting_2_foreign` (`consumable_setting_2`),
  CONSTRAINT `bond_designs_consumable_setting_1_foreign` FOREIGN KEY (`consumable_setting_1`) REFERENCES `consumable_settings` (`id`),
  CONSTRAINT `bond_designs_consumable_setting_2_foreign` FOREIGN KEY (`consumable_setting_2`) REFERENCES `consumable_settings` (`id`),
  CONSTRAINT `bond_designs_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `bond_designs_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bond_designs`
--

LOCK TABLES `bond_designs` WRITE;
/*!40000 ALTER TABLE `bond_designs` DISABLE KEYS */;
INSERT INTO `bond_designs` VALUES (1,'Gangsaw-4.0-4.5mm','23/20X19X20mm','4.5mm',1.82,1.90,3,NULL,NULL,NULL,1.86,0.00,'Powder Patti Weight',NULL,25,NULL,5.58,'BOX-SHAPE',0.50,4.50,'2020-02-14 17:52:54','2020-03-05 03:58:07',1,1),(2,'Gangsaw-4.5-5.0mm','23/20X19X20mm','5.0mm',2.13,2.19,3,NULL,NULL,NULL,2.16,0.00,'Powder Patti Weight',NULL,25,NULL,6.48,'BOX-SHAPE',0.50,5.00,'2020-02-14 17:52:54','2020-03-05 03:58:29',1,1),(3,'Gangsaw-3.5-4.0mm','23/20X19X20mm','4.0mm',1.62,1.67,3,NULL,NULL,NULL,1.65,0.00,'Powder Patti Weight',NULL,25,NULL,4.94,'BOX-SHAPE',0.50,4.00,'2020-02-14 17:52:54','2020-03-05 03:58:19',1,1),(4,'Box-24X8.5mm','24X15X8.5mm','8.5mm',1.82,1.87,4,NULL,NULL,NULL,NULL,NULL,'Powder Patti Weight',NULL,26,NULL,7.20,'BOX-SHAPE',0.00,18.00,'2020-02-14 17:52:54',NULL,1,NULL),(5,'Box-23X8.5mm','23X15X8.5mm','8.5mm',1.82,1.87,4,NULL,NULL,NULL,NULL,NULL,'Powder Patti Weight',NULL,26,NULL,7.20,'BOX-SHAPE',0.00,18.00,'2020-02-14 17:52:54',NULL,1,NULL),(6,'MShape-8.5mm','24X15X7.5/8.5mm','8.5mm',1.82,1.87,4,NULL,NULL,NULL,NULL,NULL,'Powder Patti Weight',NULL,26,NULL,7.20,'M-SHAPE',0.50,18.00,'2020-02-14 17:52:54',NULL,1,NULL),(7,'MShape-10.5mm','24X15X9.5/10.5mm','8.5mm',1.82,1.87,4,NULL,NULL,NULL,NULL,NULL,'Powder Patti Weight',NULL,26,NULL,7.20,'M-SHAPE',0.50,18.00,'2020-02-14 17:52:54',NULL,1,NULL);
/*!40000 ALTER TABLE `bond_designs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bond_invoice_detail`
--

DROP TABLE IF EXISTS `bond_invoice_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bond_invoice_detail` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint(20) unsigned NOT NULL,
  `packing_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `unit_price` decimal(25,2) DEFAULT NULL,
  `amount` decimal(25,2) DEFAULT NULL,
  `cgst` decimal(25,2) DEFAULT '0.00',
  `sgst` decimal(25,2) DEFAULT '0.00',
  `igst` decimal(25,2) DEFAULT '0.00',
  `cgst_value` decimal(25,2) DEFAULT '0.00',
  `sgst_value` decimal(25,2) DEFAULT '0.00',
  `igst_value` decimal(25,2) DEFAULT '0.00',
  `net_gst` decimal(25,2) DEFAULT '0.00',
  `discount` decimal(25,2) DEFAULT '0.00',
  `discount_val` decimal(25,2) DEFAULT '0.00',
  `net_amount` decimal(25,2) DEFAULT '0.00',
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `bond_invoice_detail_packing_id_unique` (`packing_id`),
  KEY `bond_invoice_detail_invoice_id_foreign` (`invoice_id`),
  KEY `bond_invoice_detail_created_by_foreign` (`created_by`),
  KEY `bond_invoice_detail_updated_by_foreign` (`updated_by`),
  CONSTRAINT `bond_invoice_detail_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `bond_invoice_detail_invoice_id_foreign` FOREIGN KEY (`invoice_id`) REFERENCES `invoices` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bond_invoice_detail_packing_id_foreign` FOREIGN KEY (`packing_id`) REFERENCES `production_packagings` (`packing_id`),
  CONSTRAINT `bond_invoice_detail_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bond_invoice_detail`
--

LOCK TABLES `bond_invoice_detail` WRITE;
/*!40000 ALTER TABLE `bond_invoice_detail` DISABLE KEYS */;
INSERT INTO `bond_invoice_detail` VALUES (3,22,789674,'2020-03-03 12:17:21',NULL,27.78,2500.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,2500.00,3,NULL),(4,23,413777,'2020-03-04 06:58:18',NULL,22.00,22000.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,22000.00,3,NULL),(5,24,909225,'2020-03-04 07:11:25',NULL,25.00,34000.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,34000.00,3,NULL),(6,25,393094,'2020-03-04 07:13:37',NULL,22.00,22000.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,22000.00,3,NULL),(7,28,692492,'2020-03-04 10:44:23',NULL,40.00,40000.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,40000.00,3,NULL),(18,33,814860,'2020-03-09 03:49:47',NULL,100.00,2300.00,8.00,8.00,0.00,184.00,184.00,0.00,368.00,0.00,0.00,2668.00,1,NULL),(19,34,766635,'2020-03-11 06:17:14',NULL,20.00,10000.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,10000.00,1,NULL);
/*!40000 ALTER TABLE `bond_invoice_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bond_material_recipes`
--

DROP TABLE IF EXISTS `bond_material_recipes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bond_material_recipes` (
  `material_id` bigint(20) unsigned NOT NULL,
  `bond_product_id` bigint(20) unsigned NOT NULL,
  `bond_process_id` bigint(20) unsigned NOT NULL,
  `weight` decimal(25,2) NOT NULL DEFAULT '0.00',
  `powder_cost` decimal(25,2) NOT NULL DEFAULT '0.00',
  `packing_settings_id` bigint(20) unsigned NOT NULL,
  `finishing_settings_id` bigint(20) unsigned NOT NULL,
  `total_piece_packing` decimal(25,2) DEFAULT '0.00',
  `priority` enum('NORMAL','MEDIUM','HIGH','URGENT') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'NORMAL',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`material_id`),
  UNIQUE KEY `bond_material_recipes_material_id_unique` (`material_id`),
  KEY `bond_material_recipes_bond_process_id_foreign` (`bond_process_id`),
  KEY `bond_material_recipes_created_by_foreign` (`created_by`),
  KEY `bond_material_recipes_updated_by_foreign` (`updated_by`),
  KEY `bond_material_recipes_packing_settings_id_foreign` (`packing_settings_id`),
  KEY `bond_material_recipes_finishing_settings_id_foreign` (`finishing_settings_id`),
  KEY `bond_material_recipes_bond_product_id_foreign` (`bond_product_id`),
  CONSTRAINT `bond_material_recipes_bond_process_id_foreign` FOREIGN KEY (`bond_process_id`) REFERENCES `bond_process_params` (`id`),
  CONSTRAINT `bond_material_recipes_bond_product_id_foreign` FOREIGN KEY (`bond_product_id`) REFERENCES `bond_products` (`id`),
  CONSTRAINT `bond_material_recipes_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `bond_material_recipes_finishing_settings_id_foreign` FOREIGN KEY (`finishing_settings_id`) REFERENCES `consumable_settings` (`id`),
  CONSTRAINT `bond_material_recipes_packing_settings_id_foreign` FOREIGN KEY (`packing_settings_id`) REFERENCES `consumable_settings` (`id`),
  CONSTRAINT `bond_material_recipes_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bond_material_recipes`
--

LOCK TABLES `bond_material_recipes` WRITE;
/*!40000 ALTER TABLE `bond_material_recipes` DISABLE KEYS */;
INSERT INTO `bond_material_recipes` VALUES (14002,4,1,12872.00,1.00,16,23,2000.00,'URGENT','2020-02-24 02:02:02','2020-02-26 08:38:32',1,1),(21038,5,1,22596.00,1.00,16,23,3500.00,'NORMAL','2020-03-05 06:47:37','2020-03-06 03:21:27',3,3),(27544,5,1,12112.00,1.00,16,23,2000.00,'URGENT','2020-02-26 01:53:51','2020-02-26 01:53:51',3,NULL),(38788,10,2,22190.00,1.00,17,23,1000.00,'NORMAL','2020-03-12 02:46:37','2020-03-12 02:46:37',3,NULL),(40205,5,1,12000.00,1.00,16,22,2000.00,'NORMAL','2020-03-08 15:24:56','2020-03-08 15:24:56',3,NULL),(41430,7,1,9075.00,1.00,16,23,1000.00,'MEDIUM','2020-02-27 01:49:40','2020-02-27 01:49:40',3,NULL),(47386,3,1,9654.00,1.00,15,23,1500.00,'URGENT','2020-02-24 02:03:35','2020-02-24 02:03:35',3,NULL),(51070,1,1,35398.00,1.00,16,23,5500.00,'NORMAL','2020-03-03 02:27:25','2020-03-05 06:46:24',3,3),(66066,6,1,12112.00,1.00,16,22,2000.00,'MEDIUM','2020-02-28 03:09:31','2020-02-28 03:09:31',3,NULL),(74246,11,2,33308.00,1.00,17,23,2600.00,'NORMAL','2020-02-28 08:43:09','2020-02-28 08:43:09',3,NULL),(78279,5,1,12112.00,1.00,15,23,2000.00,'NORMAL','2020-03-01 01:00:42','2020-03-01 01:00:42',3,NULL),(79748,5,1,24000.00,1.00,16,23,4000.00,'NORMAL','2020-03-07 01:15:04','2020-03-08 02:48:40',3,3),(80324,5,1,12000.00,1.00,16,23,2000.00,'NORMAL','2020-03-11 00:59:41','2020-03-11 00:59:41',3,NULL),(80675,5,1,12112.00,1.00,16,22,2000.00,'NORMAL','2020-02-28 15:33:12','2020-02-28 15:33:12',3,NULL),(85759,1,1,12872.00,1.00,15,23,2000.00,'URGENT','2020-02-25 01:34:12','2020-02-25 01:34:12',3,NULL);
/*!40000 ALTER TABLE `bond_material_recipes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bond_process_consumable`
--

DROP TABLE IF EXISTS `bond_process_consumable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bond_process_consumable` (
  `bond_process_id` bigint(20) unsigned NOT NULL,
  `consumable_settings_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`bond_process_id`,`consumable_settings_id`),
  KEY `consumable_settings_foreign` (`consumable_settings_id`),
  CONSTRAINT `bond_process_params_foreign` FOREIGN KEY (`bond_process_id`) REFERENCES `bond_process_params` (`id`) ON DELETE CASCADE,
  CONSTRAINT `consumable_settings_foreign` FOREIGN KEY (`consumable_settings_id`) REFERENCES `consumable_settings` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bond_process_consumable`
--

LOCK TABLES `bond_process_consumable` WRITE;
/*!40000 ALTER TABLE `bond_process_consumable` DISABLE KEYS */;
INSERT INTO `bond_process_consumable` VALUES (1,1,'2020-02-15 18:14:04',NULL),(1,5,'2020-02-15 18:14:04',NULL),(1,7,'2020-02-15 18:14:04',NULL),(1,15,'2020-02-15 18:14:04',NULL),(2,2,'2020-02-27 17:55:50',NULL),(2,6,'2020-02-27 17:55:50',NULL),(2,8,'2020-02-27 17:55:50',NULL),(2,12,'2020-02-27 17:55:50',NULL),(2,17,'2020-02-27 17:55:50',NULL);
/*!40000 ALTER TABLE `bond_process_consumable` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bond_process_params`
--

DROP TABLE IF EXISTS `bond_process_params`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bond_process_params` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `proc_type` enum('SANDWITCH','WIRESAW_PEARL') COLLATE utf8mb4_unicode_ci NOT NULL,
  `mixing_detail` json DEFAULT NULL,
  `hotpress_detail` json DEFAULT NULL,
  `finishing_detail` json DEFAULT NULL,
  `other_detail` json DEFAULT NULL,
  `cycle_time` decimal(25,2) DEFAULT NULL,
  `expected_mould` decimal(25,2) DEFAULT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bond_process_params_created_by_foreign` (`created_by`),
  KEY `bond_process_params_updated_by_foreign` (`updated_by`),
  CONSTRAINT `bond_process_params_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `bond_process_params_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bond_process_params`
--

LOCK TABLES `bond_process_params` WRITE;
/*!40000 ALTER TABLE `bond_process_params` DISABLE KEYS */;
INSERT INTO `bond_process_params` VALUES (1,'Gangsaw','SANDWITCH','{\"en\": \"mix\", \"hi\": \"mix\"}','{\"en\": \"hot\", \"hi\": \"hot\"}','{\"en\": \"finish\", \"hi\": \"finish\"}','{\"en\": \"other\", \"hi\": \"other\"}',13.00,4.00,1,NULL,'2020-02-15 18:14:04','2020-02-15 18:14:04'),(2,'BOX','SANDWITCH','{\"en\": \"mix powder for 3 hours\", \"hi\": \"3 घंटे के लिए पाउडर मिलाएं\"}','{\"en\": \"Use programme 1\", \"hi\": \"Use programme 1\"}','{\"en\": \"mix in tumbler for 45 minutes\", \"hi\": \"mix in tumbler for 45 minutes\"}','{\"en\": \"NA\", \"hi\": \"NA\"}',11.30,4.00,3,1,'2020-02-22 05:16:45','2020-02-27 17:55:50');
/*!40000 ALTER TABLE `bond_process_params` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bond_product_types`
--

DROP TABLE IF EXISTS `bond_product_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bond_product_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `category` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name_print` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `bond_product_types_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bond_product_types`
--

LOCK TABLES `bond_product_types` WRITE;
/*!40000 ALTER TABLE `bond_product_types` DISABLE KEYS */;
INSERT INTO `bond_product_types` VALUES (1,'Gangsaw','','','2020-02-14 17:52:54',NULL),(2,'Marble-Cutter','','','2020-02-14 17:52:54',NULL),(3,'Ganite-Cutter','','','2020-02-14 17:52:54',NULL),(4,'Mono Dressing','','','2020-02-14 17:52:54',NULL);
/*!40000 ALTER TABLE `bond_product_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bond_products`
--

DROP TABLE IF EXISTS `bond_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bond_products` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name_print` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hsn_code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bond_id` bigint(20) unsigned NOT NULL,
  `bond_design_id` bigint(20) unsigned NOT NULL,
  `bond_type_id` bigint(20) unsigned NOT NULL,
  `opening_stock` decimal(25,2) NOT NULL DEFAULT '0.00',
  `qty_unit_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `category` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `bond_products_name_unique` (`name`),
  KEY `bond_products_qty_unit_id_foreign` (`qty_unit_id`),
  KEY `bond_products_bond_type_id_foreign` (`bond_type_id`),
  CONSTRAINT `bond_products_bond_type_id_foreign` FOREIGN KEY (`bond_type_id`) REFERENCES `bond_product_types` (`id`),
  CONSTRAINT `bond_products_qty_unit_id_foreign` FOREIGN KEY (`qty_unit_id`) REFERENCES `units` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bond_products`
--

LOCK TABLES `bond_products` WRITE;
/*!40000 ALTER TABLE `bond_products` DISABLE KEYS */;
INSERT INTO `bond_products` VALUES (1,'G2 4.5mm','G2 4.5mm','82022000',1,1,1,2000.00,1,'2020-02-15 18:14:33','2020-03-08 17:41:39','Gangsaw Segment'),(3,'G2 4mm','G2 4mm','82022000',1,3,1,0.00,1,'2020-02-22 05:21:20','2020-03-08 17:41:18','Gangsaw Segment'),(4,'G3 4.5mm','G3 4.5mm','82022000',4,1,1,0.00,1,'2020-02-22 05:23:03','2020-03-08 17:41:01','Gangsaw Segment'),(5,'G51 4.5mm','G51 4.5mm','82022000',6,1,1,0.00,1,'2020-02-22 05:24:14','2020-03-08 17:40:51','Gangsaw Segment'),(6,'G22 4.5mm','G22 4.5mm','82022000',3,1,1,0.00,1,'2020-02-22 05:25:30','2020-03-08 17:41:09','Gangsaw Segment'),(7,'GPP','GPP','82022000',7,1,1,0.00,1,'2020-02-22 05:27:25','2020-03-08 17:40:06','Gangsaw Segment'),(8,'G21 4.5mm','G21 4.5mm','82079090',9,1,1,0.00,1,'2020-02-22 05:28:35','2020-03-08 17:33:36','Gangsaw Segment'),(9,'210 8.5mm','210 8.5mm',NULL,10,5,2,0.00,1,'2020-02-22 05:30:35','2020-02-22 05:30:35','Gangsaw Segment'),(10,'BOX 210 8.5mm','BOX 210 8.5',NULL,10,5,2,0.00,1,'2020-02-22 05:31:32','2020-02-22 05:31:32','Gangsaw Segment'),(11,'BOX 2210 8.5mm','BOX 2210 8.5mm',NULL,11,5,2,0.00,1,'2020-02-22 05:32:30','2020-02-22 05:32:30','Gangsaw Segment');
/*!40000 ALTER TABLE `bond_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bond_recipe_production_status`
--

DROP TABLE IF EXISTS `bond_recipe_production_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bond_recipe_production_status` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `material_id` bigint(20) unsigned NOT NULL,
  `status_id` bigint(20) unsigned NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bond_recipe_production_status_material_id_foreign` (`material_id`),
  KEY `bond_recipe_production_status_status_id_foreign` (`status_id`),
  CONSTRAINT `bond_recipe_production_status_material_id_foreign` FOREIGN KEY (`material_id`) REFERENCES `bond_material_recipes` (`material_id`) ON DELETE CASCADE,
  CONSTRAINT `bond_recipe_production_status_status_id_foreign` FOREIGN KEY (`status_id`) REFERENCES `production_status` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bond_recipe_production_status`
--

LOCK TABLES `bond_recipe_production_status` WRITE;
/*!40000 ALTER TABLE `bond_recipe_production_status` DISABLE KEYS */;
INSERT INTO `bond_recipe_production_status` VALUES (7,14002,1,3,'2020-02-24 02:02:02','2020-02-24 02:02:02'),(8,47386,1,3,'2020-02-24 02:03:35','2020-02-24 02:03:35'),(9,85759,1,3,'2020-02-25 01:34:12','2020-02-25 01:34:12'),(10,27544,1,3,'2020-02-26 01:53:51','2020-02-26 01:53:51'),(11,41430,1,3,'2020-02-27 01:49:40','2020-02-27 01:49:40'),(15,47386,4,1,'2020-02-27 18:08:02','2020-02-27 18:08:02'),(18,66066,1,3,'2020-02-28 03:09:31','2020-02-28 03:09:31'),(19,27544,2,3,'2020-02-28 08:39:46','2020-02-28 08:39:46'),(20,41430,2,3,'2020-02-28 08:40:28','2020-02-28 08:40:28'),(21,74246,1,3,'2020-02-28 08:43:09','2020-02-28 08:43:09'),(22,74246,2,3,'2020-02-28 08:46:11','2020-02-28 08:46:11'),(23,80675,1,3,'2020-02-28 15:33:12','2020-02-28 15:33:12'),(24,78279,1,3,'2020-03-01 01:00:42','2020-03-01 01:00:42'),(25,66066,2,3,'2020-03-01 06:10:45','2020-03-01 06:10:45'),(26,80675,2,2,'2020-03-01 11:44:23','2020-03-01 11:44:23'),(28,78279,2,2,'2020-03-02 11:44:29','2020-03-02 11:44:29'),(29,51070,1,3,'2020-03-03 02:27:25','2020-03-03 02:27:25'),(30,78279,2,1,'2020-03-05 02:54:17','2020-03-05 02:54:17'),(31,21038,1,3,'2020-03-05 06:47:37','2020-03-05 06:47:37'),(32,80675,4,1,'2020-03-05 09:17:20','2020-03-05 09:17:20'),(33,51070,2,2,'2020-03-05 11:44:29','2020-03-05 11:44:29'),(34,85759,2,1,'2020-03-05 17:44:53','2020-03-05 17:44:53'),(35,14002,2,1,'2020-03-05 17:45:19','2020-03-05 17:45:19'),(36,79748,1,3,'2020-03-07 01:15:04','2020-03-07 01:15:04'),(37,21038,2,2,'2020-03-07 08:28:50','2020-03-07 08:28:50'),(38,51070,4,1,'2020-03-08 08:22:18','2020-03-08 08:22:18'),(39,78279,4,1,'2020-03-08 08:25:16','2020-03-08 08:25:16'),(40,66066,4,1,'2020-03-08 08:25:52','2020-03-08 08:25:52'),(41,41430,4,1,'2020-03-08 08:26:44','2020-03-08 08:26:44'),(42,85759,4,1,'2020-03-08 08:29:19','2020-03-08 08:29:19'),(43,40205,1,3,'2020-03-08 15:24:56','2020-03-08 15:24:56'),(44,80324,1,3,'2020-03-11 00:59:41','2020-03-11 00:59:41'),(45,79748,2,1,'2020-03-11 08:10:19','2020-03-11 08:10:19'),(46,38788,1,3,'2020-03-12 02:46:37','2020-03-12 02:46:37');
/*!40000 ALTER TABLE `bond_recipe_production_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bond_recipe_productions`
--

DROP TABLE IF EXISTS `bond_recipe_productions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bond_recipe_productions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `material_id` bigint(20) unsigned NOT NULL,
  `start_time` datetime NOT NULL,
  `end_time` datetime NOT NULL,
  `duration` bigint(20) unsigned NOT NULL,
  `mould` decimal(25,2) NOT NULL,
  `remaining_piece` decimal(25,2) DEFAULT '0.00',
  `electricity_out_duration` bigint(20) DEFAULT '0',
  `other_prod_blocker_duration` bigint(20) DEFAULT '0',
  `other_blocker_reason` enum('RAW_MATERIAL_NOT_READY','RAW_MATERIAL_NOT_AVAILABLE','LESS_WORKER','OTHER') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reason` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `employee_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bond_recipe_productions_created_by_foreign` (`created_by`),
  KEY `bond_recipe_productions_updated_by_foreign` (`updated_by`),
  KEY `bond_recipe_productions_material_id_foreign` (`material_id`),
  KEY `bond_recipe_productions_employee_id_foreign` (`employee_id`),
  CONSTRAINT `bond_recipe_productions_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `bond_recipe_productions_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`),
  CONSTRAINT `bond_recipe_productions_material_id_foreign` FOREIGN KEY (`material_id`) REFERENCES `bond_material_recipes` (`material_id`),
  CONSTRAINT `bond_recipe_productions_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bond_recipe_productions`
--

LOCK TABLES `bond_recipe_productions` WRITE;
/*!40000 ALTER TABLE `bond_recipe_productions` DISABLE KEYS */;
INSERT INTO `bond_recipe_productions` VALUES (10,47386,'2020-02-25 06:10:00','2020-02-25 14:00:00',28200000,23.00,0.00,0,0,NULL,NULL,4,1,'2020-02-25 08:43:00','2020-03-08 05:02:29',2),(11,14002,'2020-02-22 14:10:00','2020-02-22 17:00:00',10200000,7.00,0.00,0,0,'OTHER',NULL,1,1,'2020-02-24 09:42:42','2020-03-08 05:01:12',1),(12,14002,'2020-02-24 06:00:00','2020-02-24 14:00:00',28800000,22.00,0.00,0,0,NULL,NULL,1,1,'2020-02-24 09:44:26','2020-03-08 05:01:27',2),(13,47386,'2020-02-26 06:10:00','2020-02-26 06:25:00',900000,1.00,0.00,0,0,NULL,NULL,1,NULL,'2020-02-26 12:06:32','2020-02-26 12:06:32',NULL),(14,85759,'2020-02-26 06:30:00','2020-02-26 14:00:00',27000000,22.00,0.00,0,0,NULL,NULL,1,NULL,'2020-02-26 12:07:35','2020-02-26 12:07:35',NULL),(15,85759,'2020-02-27 06:00:00','2020-02-27 09:00:00',10800000,9.00,0.00,0,0,NULL,NULL,2,1,'2020-02-27 08:33:11','2020-02-27 09:08:33',NULL),(16,27544,'2020-02-27 09:00:00','2020-02-27 14:00:00',18000000,13.00,0.00,0,0,NULL,NULL,2,1,'2020-02-27 08:34:42','2020-03-08 05:02:51',2),(23,27544,'2020-02-28 06:14:00','2020-02-28 14:55:00',31260000,14.00,0.00,10,0,NULL,NULL,3,1,'2020-02-28 08:39:46','2020-03-07 08:45:23',2),(24,41430,'2020-02-28 23:00:00','2020-02-28 14:00:00',32400000,8.00,0.00,0,0,NULL,NULL,3,NULL,'2020-02-28 08:40:28','2020-02-28 08:40:28',NULL),(25,74246,'2020-02-19 13:00:00','2020-02-19 14:00:00',3600000,4.00,0.00,0,0,NULL,NULL,3,NULL,'2020-02-28 08:46:11','2020-02-28 08:46:11',NULL),(26,74246,'2020-02-20 06:00:00','2020-02-20 14:00:00',28800000,42.00,0.00,0,0,NULL,NULL,3,NULL,'2020-02-28 08:46:50','2020-02-28 08:46:50',NULL),(27,74246,'2020-02-22 06:00:00','2020-02-22 11:00:00',18000000,16.00,0.00,0,0,NULL,NULL,3,NULL,'2020-02-28 08:47:54','2020-02-28 08:47:54',NULL),(28,41430,'2020-02-29 06:00:00','2020-02-29 11:35:00',20100000,12.00,0.00,0,0,NULL,NULL,3,1,'2020-03-01 06:06:00','2020-03-07 08:47:18',2),(29,66066,'2020-02-29 11:39:00','2020-02-29 14:00:00',8460000,10.00,0.00,0,0,NULL,NULL,3,1,'2020-03-01 06:10:45','2020-03-07 08:47:01',2),(31,66066,'2020-03-01 06:00:00','2020-03-01 12:40:00',24000000,19.00,0.00,0,0,NULL,NULL,2,1,'2020-03-01 11:42:24','2020-03-07 08:46:39',2),(32,80675,'2020-03-01 12:40:00','2020-03-01 14:10:00',5400000,4.00,0.00,0,0,NULL,NULL,2,1,'2020-03-01 11:44:23','2020-03-07 08:46:16',2),(33,80675,'2020-03-01 14:10:00','2020-03-01 17:00:00',10200000,8.00,0.00,0,0,NULL,NULL,2,1,'2020-03-01 11:45:53','2020-03-07 08:43:50',1),(34,80675,'2020-03-02 06:00:00','2020-03-02 12:10:00',22200000,17.00,0.00,0,0,NULL,NULL,2,1,'2020-03-02 11:37:40','2020-03-07 08:45:54',2),(35,78279,'2020-03-02 12:10:00','2020-03-02 14:01:00',6660000,5.00,0.00,0,0,NULL,NULL,2,1,'2020-03-02 11:44:29','2020-03-07 08:43:36',2),(36,78279,'2020-03-02 14:00:00','2020-03-02 17:00:00',10800000,8.00,0.00,0,0,NULL,NULL,2,1,'2020-03-02 11:45:43','2020-03-07 08:43:21',1),(37,78279,'2020-03-03 06:10:00','2020-03-03 06:40:00',1800000,2.00,0.00,0,0,NULL,NULL,2,NULL,'2020-03-03 09:06:39','2020-03-03 09:06:39',NULL),(38,78279,'2020-03-04 11:50:00','2020-03-04 17:00:00',18600000,15.00,0.00,30,0,NULL,NULL,2,1,'2020-03-04 11:43:29','2020-03-07 08:42:03',2),(39,51070,'2020-03-05 06:00:00','2020-03-05 14:00:00',28800000,23.00,0.00,0,0,NULL,NULL,2,1,'2020-03-05 11:44:29','2020-03-07 08:41:49',2),(40,51070,'2020-03-05 14:00:00','2020-03-05 17:00:00',10800000,8.00,0.00,0,0,NULL,NULL,2,1,'2020-03-05 11:45:40','2020-03-07 04:04:18',1),(41,51070,'2020-03-06 07:00:00','2020-03-06 14:00:00',25200000,22.00,0.00,0,0,NULL,NULL,2,1,'2020-03-06 08:25:48','2020-03-07 04:04:09',2),(42,51070,'2020-03-06 14:00:00','2020-03-06 17:01:00',10860000,9.00,0.00,0,0,NULL,NULL,2,1,'2020-03-06 11:33:19','2020-03-07 04:03:32',1),(47,51070,'2020-03-07 06:00:00','2020-03-07 09:30:00',12600000,11.00,0.00,0,0,NULL,NULL,2,NULL,'2020-03-07 08:14:49','2020-03-07 08:14:49',2),(48,21038,'2020-03-07 09:30:00','2020-03-07 14:00:00',16200000,12.00,0.00,0,0,NULL,NULL,2,NULL,'2020-03-07 08:28:50','2020-03-07 08:28:50',2),(49,21038,'2020-03-07 10:00:00','2020-03-07 22:30:00',45000000,2.00,0.00,0,0,NULL,NULL,2,NULL,'2020-03-07 08:42:11','2020-03-07 08:42:11',1),(50,51070,'2020-03-07 14:10:00','2020-03-07 17:00:00',10200000,4.00,12.00,0,0,NULL,NULL,2,1,'2020-03-08 06:44:42','2020-03-08 08:02:49',1),(51,21038,'2020-03-08 06:00:00','2020-03-08 14:00:00',28800000,24.00,0.00,10,0,NULL,NULL,2,1,'2020-03-08 12:09:01','2020-03-08 12:16:19',2),(52,21038,'2020-03-08 14:00:00','2020-03-08 17:00:00',10800000,10.00,37.00,0,0,NULL,NULL,2,1,'2020-03-08 12:09:42','2020-03-11 08:43:26',1),(54,79748,'2020-03-09 06:10:00','2020-03-09 10:00:00',13800000,14.00,0.00,0,0,NULL,NULL,1,1,'2020-03-11 08:10:19','2020-03-11 08:38:56',2),(55,79748,'2020-03-09 10:00:00','2020-03-09 16:05:00',21900000,18.00,0.00,0,0,NULL,NULL,1,1,'2020-03-11 08:11:30','2020-03-11 08:48:14',1);
/*!40000 ALTER TABLE `bond_recipe_productions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bonds`
--

DROP TABLE IF EXISTS `bonds`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bonds` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name_print` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `machine_type` enum('GANGSAW','DRESSING','MULTIBLADE_CUTTER','SINGLE_BLADE_CUTTER','WIRESAW_MACHINE','EDGE_CUTTING') COLLATE utf8mb4_unicode_ci NOT NULL,
  `stone_type` enum('MARBLE','SANDSTONE','GRANITE','TILES','IMPORTED_STONE') COLLATE utf8mb4_unicode_ci NOT NULL,
  `bond_short_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('ACTIVE','INACTIVE','DISCONTINUED') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'ACTIVE',
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bonds_created_by_foreign` (`created_by`),
  KEY `bonds_updated_by_foreign` (`updated_by`),
  CONSTRAINT `bonds_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `bonds_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bonds`
--

LOCK TABLES `bonds` WRITE;
/*!40000 ALTER TABLE `bonds` DISABLE KEYS */;
INSERT INTO `bonds` VALUES (1,'G2',NULL,'GANGSAW','MARBLE',NULL,'ACTIVE',1,NULL,'2020-02-15 18:13:08','2020-02-15 18:13:08'),(2,'G1',NULL,'GANGSAW','MARBLE',NULL,'ACTIVE',3,NULL,'2020-02-22 05:10:36','2020-02-22 05:10:36'),(3,'G22',NULL,'GANGSAW','MARBLE',NULL,'ACTIVE',3,NULL,'2020-02-22 05:11:00','2020-02-22 05:11:00'),(4,'G3',NULL,'GANGSAW','MARBLE',NULL,'ACTIVE',3,NULL,'2020-02-22 05:11:19','2020-02-22 05:11:19'),(5,'G3+',NULL,'GANGSAW','MARBLE',NULL,'ACTIVE',3,NULL,'2020-02-22 05:11:49','2020-02-22 05:11:49'),(6,'G51',NULL,'GANGSAW','MARBLE',NULL,'ACTIVE',3,NULL,'2020-02-22 05:12:09','2020-02-22 05:12:09'),(7,'GPP',NULL,'GANGSAW','MARBLE',NULL,'ACTIVE',3,NULL,'2020-02-22 05:12:49','2020-02-22 05:12:49'),(8,'G23',NULL,'GANGSAW','MARBLE',NULL,'ACTIVE',3,NULL,'2020-02-22 05:13:10','2020-02-22 05:13:10'),(9,'G21',NULL,'GANGSAW','MARBLE',NULL,'ACTIVE',3,NULL,'2020-02-22 05:13:37','2020-02-22 05:13:37'),(10,'210',NULL,'GANGSAW','MARBLE',NULL,'ACTIVE',3,NULL,'2020-02-22 05:14:13','2020-02-22 05:14:13'),(11,'2210',NULL,'GANGSAW','MARBLE',NULL,'ACTIVE',3,NULL,'2020-02-22 05:14:42','2020-02-22 05:14:42');
/*!40000 ALTER TABLE `bonds` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `company_detail`
--

DROP TABLE IF EXISTS `company_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `company_detail` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tag_line` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `gstNo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `web_address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone1` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone2` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone3` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email1` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email2` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_prefix` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_detail` text COLLATE utf8mb4_unicode_ci,
  `tnc` text COLLATE utf8mb4_unicode_ci,
  `logo_path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `watermark_path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `signature_footer` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `declaration_note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `detail_footer` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `company_detail`
--

LOCK TABLES `company_detail` WRITE;
/*!40000 ALTER TABLE `company_detail` DISABLE KEYS */;
INSERT INTO `company_detail` VALUES (1,'Amar SuperHard Tools','Never Stop','Bus Stand Morchana, Ajmer Udaipur Highway Road(NH8) <br> Rajsamand Rajasthan, INDIA <br> PinCode :313324','08BHYPP0088H1ZN','amar.superhard@gmail.com','www.amarsuperhardtools.com','+91-9413319707','+91-9414220874','+91-9958859998','hello@amarsuperhardtools.com',NULL,NULL,'A/C Name : Amar SuperHard Tools <br>Bank Name: Axis Bank <br>A/C No : 918020103188858 <br>IFSC : UTIB0003293','Terms & Conditions <br>Good sold once will not taken back. <br>All Subject to Rajsamand Jurisdiction only<br>Interest @ 18% will be charged if invoice is not paid within 7 days','','','2020-03-09 06:42:59',NULL,'Authorised Signatory<br> <strong>Amar SuperHard Tools</strong>','Declaration<br>We declare that this invoice shows the actual price of the goods described and that all particulars are true and correct','Manufacturer of All kind of diamond tools');
/*!40000 ALTER TABLE `company_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumable_categories`
--

DROP TABLE IF EXISTS `consumable_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consumable_categories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` json NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `consumable_categories_created_by_foreign` (`created_by`),
  KEY `consumable_categories_updated_by_foreign` (`updated_by`),
  CONSTRAINT `consumable_categories_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `consumable_categories_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumable_categories`
--

LOCK TABLES `consumable_categories` WRITE;
/*!40000 ALTER TABLE `consumable_categories` DISABLE KEYS */;
INSERT INTO `consumable_categories` VALUES (1,'2020-02-14 17:52:53',NULL,'{\"en\": \"Mould\", \"hi\": \"\"}',1,NULL),(2,'2020-02-14 17:52:53',NULL,'{\"en\": \"Iron Patti\", \"hi\": \"\"}',1,NULL),(3,'2020-02-14 17:52:53',NULL,'{\"en\": \"Chemical\", \"hi\": \"\"}',1,NULL),(4,'2020-02-14 17:52:53',NULL,'{\"en\": \"Grinding Wheel\", \"hi\": \"\"}',1,NULL),(5,'2020-02-14 17:52:53',NULL,'{\"en\": \"Binder\", \"hi\": \"\"}',1,NULL),(6,'2020-02-14 17:52:53',NULL,'{\"en\": \"Die\", \"hi\": \"\"}',1,NULL),(7,'2020-02-14 17:52:54',NULL,'{\"en\": \"Coldpress Accesories\", \"hi\": \"\"}',1,NULL),(8,'2020-02-14 17:52:54',NULL,'{\"en\": \"Hotpress Accesories\", \"hi\": \"\"}',1,NULL),(9,'2020-02-26 03:41:52','2020-02-26 03:41:52','{\"en\": \"Bond Materials\", \"hi\": \"Bond Materials\"}',1,NULL),(10,'2020-02-28 06:32:49','2020-02-28 06:32:49','{\"en\": \"Graphite Materials\", \"hi\": \"Graphite Materials\"}',1,NULL);
/*!40000 ALTER TABLE `consumable_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumable_consumpation_details`
--

DROP TABLE IF EXISTS `consumable_consumpation_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consumable_consumpation_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `consumpation_id` bigint(20) unsigned NOT NULL,
  `consumable_id` bigint(20) unsigned NOT NULL,
  `qty` decimal(25,2) NOT NULL,
  `consumed_percentage` decimal(10,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `consumable_consumpation_details_created_by_foreign` (`created_by`),
  KEY `consumable_consumpation_details_updated_by_foreign` (`updated_by`),
  KEY `consumable_consumpation_details_consumpation_id_foreign` (`consumpation_id`),
  KEY `consumable_consumpation_details_consumable_id_foreign` (`consumable_id`),
  CONSTRAINT `consumable_consumpation_details_consumable_id_foreign` FOREIGN KEY (`consumable_id`) REFERENCES `consumable_items` (`id`),
  CONSTRAINT `consumable_consumpation_details_consumpation_id_foreign` FOREIGN KEY (`consumpation_id`) REFERENCES `consumable_consumpations` (`id`) ON DELETE CASCADE,
  CONSTRAINT `consumable_consumpation_details_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `consumable_consumpation_details_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumable_consumpation_details`
--

LOCK TABLES `consumable_consumpation_details` WRITE;
/*!40000 ALTER TABLE `consumable_consumpation_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumable_consumpation_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumable_consumpations`
--

DROP TABLE IF EXISTS `consumable_consumpations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consumable_consumpations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `change_date` datetime NOT NULL,
  `narration` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `change_reason` enum('REGULAR_ROUTINE','MATERIAL_FAULT','MACHINE_FAULT','OTHER') COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumable_consumpations`
--

LOCK TABLES `consumable_consumpations` WRITE;
/*!40000 ALTER TABLE `consumable_consumpations` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumable_consumpations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumable_details`
--

DROP TABLE IF EXISTS `consumable_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consumable_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `consumable_id` bigint(20) unsigned DEFAULT NULL,
  `item_id` bigint(20) unsigned NOT NULL,
  `qty` decimal(8,2) DEFAULT NULL,
  `qty_type` enum('PERCENTAGE','UNIT') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expected_pcs` decimal(25,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `consumable_details_consumable_id_foreign` (`consumable_id`),
  CONSTRAINT `consumable_details_consumable_id_foreign` FOREIGN KEY (`consumable_id`) REFERENCES `consumable_settings` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumable_details`
--

LOCK TABLES `consumable_details` WRITE;
/*!40000 ALTER TABLE `consumable_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumable_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumable_items`
--

DROP TABLE IF EXISTS `consumable_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consumable_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` json NOT NULL,
  `spec` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `add_spec` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `weight` decimal(25,2) DEFAULT NULL,
  `description` json DEFAULT NULL,
  `opening_stock` decimal(25,2) DEFAULT NULL,
  `unit_price` decimal(25,2) DEFAULT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  `opening_stock_unit` bigint(20) unsigned DEFAULT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `consumable_items_opening_stock_unit_foreign` (`opening_stock_unit`),
  KEY `consumable_items_created_by_foreign` (`created_by`),
  KEY `consumable_items_updated_by_foreign` (`updated_by`),
  KEY `consumable_items_category_id_foreign` (`category_id`),
  CONSTRAINT `consumable_items_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `consumable_categories` (`id`),
  CONSTRAINT `consumable_items_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `consumable_items_opening_stock_unit_foreign` FOREIGN KEY (`opening_stock_unit`) REFERENCES `units` (`id`),
  CONSTRAINT `consumable_items_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumable_items`
--

LOCK TABLES `consumable_items` WRITE;
/*!40000 ALTER TABLE `consumable_items` DISABLE KEYS */;
INSERT INTO `consumable_items` VALUES (1,'2020-02-14 17:52:54',NULL,'{\"en\": \"GangSaw-BigPunch\", \"hi\": \"\"}','23/20X10X30mm',NULL,NULL,NULL,216.00,24.00,1,1,1,NULL),(2,'2020-02-14 17:52:54',NULL,'{\"en\": \"GangSaw-MiddlePunch\", \"hi\": \"\"}','23/20X10X18mm',NULL,NULL,NULL,216.00,18.00,1,1,1,NULL),(3,'2020-02-14 17:52:54',NULL,'{\"en\": \"GangSaw-SmallPunch\", \"hi\": \"\"}','23/20X10X15mm',NULL,NULL,NULL,432.00,15.00,1,1,1,NULL),(4,'2020-02-14 17:52:54',NULL,'{\"en\": \"GangSaw-Spencer\", \"hi\": \"\"}','80X10X20mm',NULL,NULL,NULL,432.00,55.00,1,1,1,NULL),(5,'2020-02-14 17:52:54',NULL,'{\"en\": \"GangSaw-GraphitePlates\", \"hi\": \"\"}','80X12X82mm',NULL,NULL,NULL,18.00,120.00,1,1,1,NULL),(6,'2020-02-14 17:52:54',NULL,'{\"en\": \"Dressing-BigPunch\", \"hi\": \"\"}','26/23X10X37mm - V Shape',NULL,NULL,NULL,18.00,35.00,1,1,1,NULL),(7,'2020-02-14 17:52:54',NULL,'{\"en\": \"Dressing-MiddlePunch\", \"hi\": \"\"}','26/23X10X22mm - V Shape',NULL,NULL,NULL,18.00,20.00,1,1,1,NULL),(8,'2020-02-14 17:52:54',NULL,'{\"en\": \"Dressing-SmallPunch\", \"hi\": \"\"}','26/23X10X20mm - V Shape',NULL,NULL,NULL,18.00,20.00,1,1,1,NULL),(9,'2020-02-14 17:52:54',NULL,'{\"en\": \"Dressing-Spencer\", \"hi\": \"\"}','80X10X20mm - V Shape',NULL,NULL,NULL,432.00,56.00,1,1,1,NULL),(10,'2020-02-14 17:52:54',NULL,'{\"en\": \"Dressing Side Plates(L)\", \"hi\": \"\"}','90X40X12',NULL,NULL,NULL,432.00,56.00,1,1,1,NULL),(11,'2020-02-14 17:52:54',NULL,'{\"en\": \"Dressing Center Plates\", \"hi\": \"\"}','75X95X12',NULL,NULL,NULL,432.00,56.00,1,1,1,NULL),(12,'2020-02-14 17:52:54',NULL,'{\"en\": \"Dressing Side Plates\", \"hi\": \"\"}','75X95X12',NULL,NULL,NULL,432.00,56.00,1,1,1,NULL),(13,'2020-02-14 17:52:54',NULL,'{\"en\": \"Graphite-Block-50mm\", \"hi\": \"\"}','130X130X50mm',NULL,NULL,NULL,4.00,1550.00,1,1,1,NULL),(14,'2020-02-14 17:52:54',NULL,'{\"en\": \"IPA\", \"hi\": \"\"}','deepak',NULL,NULL,NULL,20.00,85.00,3,4,1,NULL),(15,'2020-02-14 17:52:54',NULL,'{\"en\": \"Acetone\", \"hi\": \"\"}','Herdalia',NULL,NULL,NULL,20.00,82.00,3,4,1,NULL),(16,'2020-02-14 17:52:54',NULL,'{\"en\": \"MDC\", \"hi\": \"\"}','Taiwan',NULL,NULL,NULL,150.00,79.00,3,4,1,NULL),(17,'2020-02-14 17:52:54',NULL,'{\"en\": \"Acrylic Resin Binder\", \"hi\": \"\"}','small powder dana',NULL,NULL,NULL,10.00,450.00,3,2,1,NULL),(18,'2020-02-14 17:52:54',NULL,'{\"en\": \"Plastic Dana Binder\", \"hi\": \"\"}','coarse powder dana',NULL,NULL,NULL,0.00,200.00,3,2,1,NULL),(19,'2020-02-14 17:52:54',NULL,'{\"en\": \"Gangsaw Die\", \"hi\": \"\"}','small powder dana',NULL,NULL,NULL,150.00,8000.00,7,1,1,NULL),(20,'2020-02-14 17:52:54',NULL,'{\"en\": \"ColdPress Rubber\", \"hi\": \"\"}','coldpress rubber',NULL,NULL,NULL,150.00,8000.00,8,1,1,NULL),(21,'2020-02-14 17:52:54',NULL,'{\"en\": \"MShape-SmallPunch\", \"hi\": \"\"}','24X10X15mm',NULL,NULL,NULL,0.00,20.00,1,1,1,NULL),(22,'2020-02-14 17:52:54',NULL,'{\"en\": \"MShape-BigPunch\", \"hi\": \"\"}','24X24X15mm',NULL,NULL,NULL,0.00,32.00,1,1,1,NULL),(23,'2020-02-14 17:52:54',NULL,'{\"en\": \"MShape-Spencer\", \"hi\": \"\"}','80X24X10mm',NULL,NULL,NULL,0.00,61.00,1,1,1,NULL),(24,'2020-02-14 17:52:54',NULL,'{\"en\": \"Plain-Spencer\", \"hi\": \"\"}','80X24X10mm',NULL,NULL,NULL,0.00,55.00,1,1,1,NULL),(25,'2020-02-14 17:52:54',NULL,'{\"en\": \"BoxType-23mm-BigPunch\", \"hi\": \"\"}','23X15X36mm',NULL,NULL,NULL,0.00,34.00,1,1,1,NULL),(26,'2020-02-14 17:52:54',NULL,'{\"en\": \"BoxType-23mm-MiddlePunch\", \"hi\": \"\"}','23X15X22mm',NULL,NULL,NULL,0.00,20.00,1,1,1,NULL),(27,'2020-02-14 17:52:54',NULL,'{\"en\": \"BoxType-23mm-SmallPunch\", \"hi\": \"\"}','23X15X18mm',NULL,NULL,NULL,0.00,16.00,1,1,1,NULL),(28,'2020-02-14 17:52:54',NULL,'{\"en\": \"BoxType-23mm-SmallPunch\", \"hi\": \"\"}','23X15X18mm',NULL,NULL,NULL,0.00,16.00,1,1,1,NULL),(29,'2020-02-14 17:52:54',NULL,'{\"en\": \"Natural Sand\", \"hi\": \"\"}','23X15X18mm',NULL,NULL,NULL,0.00,1.00,1,3,1,NULL),(30,'2020-02-26 03:42:40','2020-02-26 03:42:40','{\"en\": \"Metal Powder\", \"hi\": \"Metal Powder\"}',NULL,NULL,0.00,'{\"en\": null, \"hi\": null}',0.00,0.00,9,2,1,NULL),(31,'2020-02-26 03:43:05','2020-02-26 03:43:05','{\"en\": \"Diamond Powder\", \"hi\": \"Diamond Powder\"}',NULL,NULL,0.00,'{\"en\": null, \"hi\": null}',0.00,0.00,9,2,1,NULL),(32,'2020-02-28 06:30:46','2020-02-28 06:30:46','{\"en\": \"Gangsaw Big Patti\", \"hi\": \"Gangsaw Big Patti\"}','22.3X19.3X0.5 MM',NULL,NULL,'{\"en\": \"Gangsaw Big Patti\", \"hi\": \"Gangsaw Big Patti\"}',0.00,0.00,2,NULL,1,NULL),(33,'2020-02-28 06:31:34','2020-02-28 06:31:34','{\"en\": \"Box Big Patti\", \"hi\": \"Box Big Patti\"}','22.75X14.75X1MM',NULL,0.00,'{\"en\": \"Box Big Patti\", \"hi\": \"Box Big Patti\"}',0.00,0.00,2,NULL,1,NULL),(34,'2020-02-28 06:34:06','2020-02-28 06:34:06','{\"en\": \"Gangsaw Graphite Plate (81X81X10)\", \"hi\": \"Gangsaw Graphite Plate (81X81X10)\"}','81X81X10 mm',NULL,0.00,'{\"en\": \"Gangsaw Graphite Plate (81X81X10)\", \"hi\": \"Gangsaw Graphite Plate (81X81X10)\"}',0.00,0.00,10,1,1,NULL),(35,'2020-02-28 06:35:05','2020-02-28 06:35:05','{\"en\": \"Box Big Punch (23X15X36)\", \"hi\": \"Box Big Punch (23X15X36)\"}','23X15X36 MM',NULL,0.00,'{\"en\": \"Box Big Punch (23X15X36)\", \"hi\": \"Box Big Punch (23X15X36)\"}',0.00,0.00,10,1,1,NULL),(36,'2020-02-28 07:04:05','2020-02-28 07:04:05','{\"en\": \"Box Middle Punch (23X15X22)\", \"hi\": \"Box Middle Punch (23X15X22)\"}','23X15X22 MM No Taper',NULL,0.00,'{\"en\": \"Box Middle Punch (23X15X22)\", \"hi\": \"Box Middle Punch (23X15X22)\"}',0.00,0.00,10,1,1,NULL),(37,'2020-02-28 07:04:46','2020-02-28 07:04:46','{\"en\": \"Box Small Punch (23X15X18)\", \"hi\": \"Box Small Punch (23X15X18)\"}','23X15X18 MM No Taper',NULL,0.00,'{\"en\": \"Box Small Punch (23X15X18)\", \"hi\": \"Box Small Punch (23X15X18)\"}',0.00,0.00,10,1,1,NULL),(38,'2020-02-28 07:06:01','2020-02-28 07:11:01','{\"en\": \"Box Side L Plate (80X100X10)\", \"hi\": \"Box Side L Plate (80X100X10)\"}','80X100X10 MM',NULL,0.00,'{\"en\": \"Box Side L Plate (80X100X10)\", \"hi\": \"Box Side L Plate (80X100X10)\"}',0.00,0.00,10,1,1,1),(39,'2020-02-28 07:06:44','2020-02-28 07:06:44','{\"en\": \"Box Side R Plate (80X85X10)\", \"hi\": \"Box Side R Plate (80X85X10)\"}','80X85X10 MM',NULL,0.00,'{\"en\": \"Box Side R Plate (80X85X10)\", \"hi\": \"Box Side R Plate (80X85X10)\"}',0.00,0.00,10,1,1,NULL),(40,'2020-02-28 07:07:53','2020-02-28 07:07:53','{\"en\": \"Grangsaw Big Punch (23/20X10X30)\", \"hi\": \"Grangsaw Big Punch (23/20X10X30)\"}','23/20X10X30 MM .25MM Taper Each Side',NULL,0.00,'{\"en\": \"Grangsaw Big Punch (23/20X10X30)\", \"hi\": \"Grangsaw Big Punch (23/20X10X30)\"}',0.00,0.00,10,1,1,NULL),(41,'2020-02-28 07:08:32','2020-02-28 07:08:32','{\"en\": \"Gangsaw Middle Punch (23/20X10X18)\", \"hi\": \"Gangsaw Middle Punch (23/20X10X18)\"}','23/20X10X18 MM .25MM Taper Each Side',NULL,0.00,'{\"en\": \"Gangsaw Middle Punch (23/20X10X18)\", \"hi\": \"Gangsaw Middle Punch (23/20X10X18)\"}',0.00,0.00,10,1,1,NULL),(42,'2020-02-28 07:09:39','2020-02-28 07:09:39','{\"en\": \"Gangsaw Small Punch (23/20X10X15)\", \"hi\": \"Gangsaw Small Punch (23/20X10X15)\"}','23/20X10X15 MM .25MM Taper Each Side',NULL,0.00,'{\"en\": \"Gangsaw Small Punch (23/20X10X15)\", \"hi\": \"Gangsaw Small Punch (23/20X10X15)\"}',0.00,0.00,10,1,1,NULL),(43,'2020-02-28 07:10:24','2020-02-28 07:10:24','{\"en\": \"Gangsaw Spencer (80X10X20)\", \"hi\": \"Gangsaw Spencer (80X10X20)\"}','80X10X20 MM',NULL,0.00,'{\"en\": \"Gangsaw Spencer (80X10X20)\", \"hi\": \"Gangsaw Spencer (80X10X20)\"}',0.00,0.00,10,1,1,NULL),(44,'2020-03-07 01:28:02','2020-03-07 01:28:02','{\"en\": \"8 Inch Grinding Wheel\", \"hi\": \"8 Inch Grinding Wheel\"}','8 Inch',NULL,0.00,'{\"en\": \"8 Inch Grinding Wheel\", \"hi\": \"8 Inch Grinding Wheel\"}',0.00,0.00,4,NULL,1,NULL);
/*!40000 ALTER TABLE `consumable_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumable_settings`
--

DROP TABLE IF EXISTS `consumable_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consumable_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` enum('COLDPRESS_DIE','PATTI','THERMOCOUPLE','MOULD','PACKING','BEAD_RUBBER_COATING','BEAD_PLASTIC_COATING','GRINDING','FINISHING','HOT_PRESS_ACCESSORIES','COLD_PRESS_ACCESSORIES','BINDER','OTHER') COLLATE utf8mb4_unicode_ci NOT NULL,
  `qty` decimal(25,2) DEFAULT NULL,
  `qty_type` enum('PERCENTAGE','UNIT') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned DEFAULT NULL,
  `deleted_by` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `consumable_settings_created_by_foreign` (`created_by`),
  KEY `consumable_settings_updated_by_foreign` (`updated_by`),
  KEY `consumable_settings_deleted_by_foreign` (`deleted_by`),
  CONSTRAINT `consumable_settings_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `consumable_settings_deleted_by_foreign` FOREIGN KEY (`deleted_by`) REFERENCES `users` (`id`),
  CONSTRAINT `consumable_settings_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumable_settings`
--

LOCK TABLES `consumable_settings` WRITE;
/*!40000 ALTER TABLE `consumable_settings` DISABLE KEYS */;
INSERT INTO `consumable_settings` VALUES (1,'2020-02-14 17:52:54',NULL,'GangsawMouldSettings','GangsawMouldSettings','Gangsaw Mould Cost','MOULD',72.00,'UNIT',1,NULL,NULL),(2,'2020-02-14 17:52:54',NULL,'BoxMouldSettings','BoxMouldSettings','Box Mould Cost','MOULD',36.00,'UNIT',1,NULL,NULL),(3,'2020-02-14 17:52:54',NULL,'MShapeMouldSettings','MShapeMouldSettings','MShape Mould Cost','MOULD',36.00,'UNIT',1,NULL,NULL),(4,'2020-02-14 17:52:54',NULL,'DressingMouldSettings','DressingMouldSettings','Dressing Mould Cost','MOULD',48.00,'UNIT',1,NULL,NULL),(5,'2020-02-14 17:52:54',NULL,'IpaAcetoneGenericBinderSettings','IpaAcetoneGenericBinderSettings','Binder Cost','BINDER',8.00,'PERCENTAGE',1,NULL,NULL),(6,'2020-02-14 17:52:54',NULL,'IpaAcetoneBoxGenericBinderSettings','IpaAcetoneGenericBinderSettings','Binder Cost','BINDER',10.00,'PERCENTAGE',1,NULL,NULL),(7,'2020-02-14 17:52:54',NULL,'GangsawDieSettings','GangsawDieSettings','Gangsaw Die Cost','COLDPRESS_DIE',NULL,NULL,1,NULL,NULL),(8,'2020-02-14 17:52:54',NULL,'BoxDieSettings','BoxDieSettings','Box Die Cost','COLDPRESS_DIE',NULL,NULL,1,NULL,NULL),(9,'2020-02-14 17:52:54',NULL,'DressingDieSettings','DressingDieSettings','Dressing Die Cost','COLDPRESS_DIE',NULL,NULL,1,NULL,NULL),(10,'2020-02-14 17:52:54',NULL,'MShapeDieSettings','MShapeDieSettings','MShape Die Cost','COLDPRESS_DIE',NULL,NULL,1,NULL,NULL),(11,'2020-02-14 17:52:54',NULL,'GangsawGrindingWheelSettings','GangsawGrindingWheelSettings','GrindingWheel Cost','GRINDING',NULL,NULL,1,NULL,NULL),(12,'2020-02-14 17:52:54',NULL,'BoxGrindingWheelSettings','BoxGrindingWheelSettings','GrindingWheel Cost','GRINDING',NULL,NULL,1,NULL,NULL),(13,'2020-02-14 17:52:54',NULL,'MShapeGrindingWheelSettings','MShapeGrindingWheelSettings','GrindingWheel Cost','GRINDING',NULL,NULL,1,NULL,NULL),(14,'2020-02-14 17:52:54',NULL,'DressingGrindingWheelSettings','DressingGrindingWheelSettings','GrindingWheel Cost','GRINDING',NULL,NULL,1,NULL,NULL),(15,'2020-02-14 17:52:54',NULL,'GangsawPolythenePackingSettings','GangsawPolythenePackingSettings','Gangsaw Polythene Packing Cost','PACKING',800.00,'UNIT',1,NULL,NULL),(16,'2020-02-14 17:52:54',NULL,'GangsawPouchPackingSettings','GangsawPouchPackingSettings','Gangsaw Pouch Packing Cost','PACKING',800.00,'UNIT',1,NULL,NULL),(17,'2020-02-14 17:52:54',NULL,'BoxPouchPackingSettings','BoxPouchPackingSettings','Box Pouch Packing Cost','PACKING',90.00,'UNIT',1,NULL,NULL),(18,'2020-02-14 17:52:54',NULL,'DressingPouchPackingSettings','DressingPouchPackingSettings','Dressing Pouch Packing Cost','PACKING',33.00,'UNIT',1,NULL,NULL),(19,'2020-02-14 17:52:54',NULL,'GangsawThermocoupleSettings','GangsawThermocoupleSettings','Gangsaw Thermocouple Cost','THERMOCOUPLE',NULL,NULL,1,NULL,NULL),(20,'2020-02-14 17:52:54',NULL,'DressingThermocoupleSettings','DressingThermocoupleSettings','Dressing Thermocouple Cost','THERMOCOUPLE',NULL,NULL,1,NULL,NULL),(21,'2020-02-14 17:52:54',NULL,'BoxThermocoupleSettings','BoxThermocoupleSettings','Box Thermocouple Cost','THERMOCOUPLE',NULL,NULL,1,NULL,NULL),(22,'2020-02-14 17:52:54',NULL,'NaturalSandFinisingSettings','NaturalSandFinisingSettings','Sand Finising','FINISHING',NULL,NULL,1,NULL,NULL),(23,'2020-02-14 17:52:54',NULL,'SandBlasingFinisingSettings','SandBlasingFinisingSettings','Sand Blasting Finising','FINISHING',NULL,NULL,1,NULL,NULL),(24,'2020-02-14 17:52:54',NULL,'EletroplatingFinisingSettings','EletroplatingFinisingSettings','Electroplating Finising','FINISHING',NULL,NULL,1,NULL,NULL),(25,'2020-02-14 17:52:54',NULL,'GangsawPattiSettings-23mm','GangsawPattiSettings-23mm','Gangsaw-Patti-23mm','PATTI',NULL,NULL,1,NULL,NULL),(26,'2020-02-14 17:52:54',NULL,'BoxPattiSettings-23mm','BoxPattiSettings-23mm','Box-Patti-23mm','PATTI',NULL,NULL,1,NULL,NULL);
/*!40000 ALTER TABLE `consumable_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Temporary table structure for view `consumable_stock_view`
--

DROP TABLE IF EXISTS `consumable_stock_view`;
