<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\AppBaseController;
use Illuminate\Support\Facades\DB;

class AccountStatementAPIController extends AppBaseController
{

    var $array = array();

    public function getGroups(){
        $groups = \App\Models\AccountGroup::whereNull('parent_id')->get();
        return $this->listCategories($groups);    
    }
    var $level =0;

    public function listCategories($categories, $level=0)
    {
        $data = [];
        if(!empty($categories)){
            foreach($categories as $category)
            {
                $data[] = [
                    'id' => $category->id,
                    'name' => $category->name,
                    'children' => $this->listCategories($category->childs, $level+1),
                    'level' => $level
                ];
                //$this->level=$this->level+1;
            }
        }else{
            //$this->level=0;
        }
        

        return $data;
    }

    public function accountList($groupId){
        return DB::table('account_total_view')->selectRaw('account_id, name, account_group, sum(cr_total) as cr_total, sum(dr_total) as dr_total, group_id')->groupBy('name')->having('group_id','=',$groupId)->get();
    }

    public function monthList($accountId){
        $data = DB::table('account_view')->selectRaw('account_id, name, account_group, month, op_balance_cr, op_balance_dr, sum(cr_total) as cr_total, sum(dr_total) as dr_total')->groupBy('month')->where('account_id','=',$accountId)->orderBy('yearmonthindex', 'ASC')->get();
        return $data;
    }

    public function transaction($accountId, $month){
        $data = DB::table('account_view')->where([['account_id','=',$accountId],['month','=',$month]])->orderBy('tr_date', 'ASC')->paginate(config('app_data.per_page_data'));;
        return  new \App\Http\Resources\BasePaginationResourceCollection($data, collect($data->items()), null);
    }
}