<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\AppBaseController;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class ConsumableStockAPIController extends AppBaseController
{
    public function stock(Request $request){
        $category = $request->get('category_id');
        $product = $request->get('product_id');
        if(!empty($category)){
            return DB::table('consumable_stock_view')->selectRaw('id, consumable_name,spec , sum(stock_value) as stock_value, sum(qty) as qty, category_id')->groupBy('consumable_name')->having('category_id', $category)->orderBy('qty','DESC')->get();
        }else if(!empty($product)){
            return DB::table('consumable_stock_view')->where('id', '=', $product)->orderBy('consumable_name','ASC')->get();    
        }
        return DB::table('consumable_stock_view')->selectRaw('category , count(distinct consumable_name) as product_count, sum(stock_value) as stock_value, category_id')->groupBy('category')->orderBy('category','ASC')->get();
    }
}