<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;

/**
 * Class ConsumableItem
 * @package App\Models
 * @version October 13, 2019, 7:31 pm UTC
 *
 */
class ConsumableItem extends CRUDAwareModel
{
    //use SoftDeletes;
    use HasTranslations;

    public $table = 'consumable_items';
    

    protected $dates = ['deleted_at'];


    public $fillable = [
        'name',
        'spec',
        'category_id',
        'opening_stock',
        'unit_price',
        'description',
        'weight'
    ];

    public $translatable = ['name', 'description'];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'opening_stock' => 'float',
        'weight' => 'float'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'name.*' => 'required|unique_translation:consumable_items',
        'category_id' => 'required|exists:consumable_categories,id',
        'opening_stock' => 'nullable|numeric',
        'unit_price' => 'nullable|numeric',
        'weight' => 'nullable|numeric'
    ];

    public static $updateRules = [
        'name.*' => 'required|unique_translation:consumable_items',
        'category_id' => 'required|exists:consumable_categories,id',
        'opening_stock' => 'nullable|numeric',
        'unit_price' => 'nullable|numeric',
        'weight' => 'nullable|numeric'
    ];

    public function category()
    {
        return $this->belongsTo('App\Models\ConsumableCategory','category_id');
    }
    
    public function unit()
    {
        return $this->belongsTo('App\Models\Unit','opening_stock_unit');
    }
}
