<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersTable extends Migration
{

    
    public static function f($m){
        $new_m = array();
        foreach ($m as $key => $value) {
            //foreach ($item as $key => $value) {
                if(!empty($value)){
                    array_push($new_m, $value);
                }
            //} 
        }
        return $new_m;
    }
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name');
            $table->string('username')->unique();
            $table->string('email')->nullable(true);
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->string('phone',15)->nullable(true);
            $table->string('address')->nullable(true);
            $table->json('preferences')->nullable(true);
            $table->timestamp('password_changed_at')->nullable(true);
            $table->date('dob');
            $table->enum('status',['ACTIVE','INACTIVE','LOCKED','BLOCKED']);
            $table->string('google2fa_secret')->nullable();
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
