<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQualityChecksTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('quality_checks', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->unsignedBigInteger('material_id');

            $table->decimal('qty', 25, 2);  
            $table->decimal('rejection_under_size_qty', 25, 2)->default(0)->nullable(true);
            $table->decimal('rejection_over_size_qty', 25, 2)->default(0)->nullable(true);
            $table->decimal('rejection_shape_qty', 25, 2)->default(0)->nullable(true);
            $table->decimal('net_qty', 25, 2);  

            $priority = CreateUsersTable::f(config('app_data.rejection_reason_enum'));
            $table->enum('rejection_reason', $priority)->nullable(true);
            $table->string('reason')->nullable(true);  

            $table->timestamps();
            //$table->softDeletes();

            $table->unsignedBigInteger('created_by')->nullable(false);
            $table->unsignedBigInteger('updated_by')->nullable();
            //$table->unsignedBigInteger('deleted_by')->nullable();
            
            $table->foreign('material_id')->references('material_id')->on('bond_material_recipes')->onDelete('cascade');;
            //$table->foreign('qty_unit_id')->references('id')->on('units'); 
            $table->foreign('created_by')->references('id')->on('users');
            $table->foreign('updated_by')->references('id')->on('users');        
           // $table->foreign('deleted_by')->references('id')->on('users');      
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('quality_checks');
    }
}
