<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBondProductsTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bond_products', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name')->unique();
            $table->string('name_print')->nullable(true);
            $table->string('hsn_code')->nullable(true);
            //$table->string('name_print')->nullable(true);
            $table->unsignedBigInteger('bond_id');
            $table->unsignedBigInteger('bond_design_id');
            $table->unsignedBigInteger('bond_type_id');
            $table->decimal('opening_stock', 25,2)->default(0);

            $table->unsignedBigInteger('qty_unit_id');

            $table->timestamps();
        });

        Schema::table('bond_material_recipes', function (Blueprint $table) {
            $table->foreign('bond_product_id')->references('id')->on('bond_products');
        });
        Schema::table('bond_products', function (Blueprint $table) {
            $table->foreign('qty_unit_id')->references('id')->on('units');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('bond_products');
    }
}
