<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCompanyDetail extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('company_detail', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name');
            $table->string('tag_line')->nullable(true);
            $table->text('address')->nullable(true);
            $table->string('gstNo')->nullable(true);
            $table->string('email')->nullable(true);
            $table->string('web_address')->nullable(true);
            $table->string('phone1')->nullable(true);
            $table->string('phone2')->nullable(true);
            $table->string('phone3')->nullable(true);
            $table->string('email1')->nullable(true);
            $table->string('email2')->nullable(true);
            $table->string('invoice_prefix')->nullable(true);
            $table->text('bank_detail')->nullable(true);
            $table->text('tnc')->nullable(true);
            $table->string('logo_path');
            $table->string('watermark_path');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('company_detail');
    }
}
